/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.gasturbine;

import com.denfop.IUItem;
import com.denfop.api.Recipes;
import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.recipe.IHasRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockGasTurbine;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerGasTurbineController;
import com.denfop.gui.GuiCore;
import com.denfop.gui.GuiGasTurbine;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.gasturbine.IAirBearings;
import com.denfop.tiles.gasturbine.IController;
import com.denfop.tiles.gasturbine.IRecuperator;
import com.denfop.tiles.gasturbine.ISocket;
import com.denfop.tiles.gasturbine.ITank;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.tiles.reactors.graphite.IExchangerItem;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class TileEntityGasTurbineController
extends TileMultiBlockBase
implements IUpdatableTileEvent,
IController,
IHasRecipe {
    public static Map<Fluid, Integer> gasMapValue = new HashMap<Fluid, Integer>();
    public ISocket energy;
    public ITank tank;
    public boolean work;
    Fluid momentGas;
    List<IRecuperator> recuperators = new ArrayList<IRecuperator>();
    int generate = 0;
    private List<BlockPos> posesBearings;

    public TileEntityGasTurbineController(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.GasTurbineMultiBlock, BlockGasTurbine.gas_turbine_controller, pos, state);
        Recipes.recipes.addInitRecipes(this);
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.full && !this.tank.getTank().getFluid().isEmpty() && this.work) {
            FluidStack stack = this.tank.getTank().getFluid();
            if (stack.getFluid() != this.momentGas) {
                this.momentGas = stack.getFluid();
                this.generate = gasMapValue.get(stack.getFluid());
            }
            double coef = 0.0;
            boolean canWork = true;
            for (IRecuperator recuperator : this.recuperators) {
                if (recuperator.getExchanger().isEmpty()) {
                    canWork = false;
                    break;
                }
                coef += recuperator.getPower();
            }
            coef /= 4.0;
            if (canWork && this.energy.getEnergy().getFreeEnergy() >= (double)this.generate * coef) {
                this.tank.getTank().drain(1, IFluidHandler.FluidAction.EXECUTE);
                this.energy.getEnergy().addEnergy((double)this.generate * coef);
                if (this.getWorld().getGameTime() % 4L == 0L) {
                    this.spawnExhaustParticles(this.level);
                }
                if (this.getWorld().getGameTime() % 20L == 0L) {
                    for (IRecuperator recuperator : this.recuperators) {
                        ((IExchangerItem)recuperator.getExchanger().get(0).getItem()).damageItem(recuperator.getExchanger().get(0), -1);
                    }
                }
                this.energy.getEnergy().setSourceTier(EnergyNetGlobal.instance.getTierFromPower((double)this.generate * coef) + 1);
            }
        }
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        nbttagcompound.putBoolean("work", this.work);
        return super.writeToNBT(nbttagcompound);
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.work = nbttagcompound.getBoolean("work");
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer customPacketBuffer = super.writeContainerPacket();
        customPacketBuffer.writeBoolean(this.work);
        customPacketBuffer.writeBytes((ByteBuf)this.energy.getEnergy().updateComponent());
        try {
            EncoderHandler.encode(customPacketBuffer, this.tank.getTank());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return customPacketBuffer;
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        this.work = customPacketBuffer.readBoolean();
        try {
            this.energy.getEnergy().onNetworkUpdate(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            FluidTank fluidTank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            if (fluidTank != null) {
                this.tank.getTank().readFromNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), fluidTank.writeToNBT((HolderLookup.Provider)customPacketBuffer.registryAccess(), new CompoundTag()));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ContainerGasTurbineController getGuiContainer(Player entityPlayer) {
        return new ContainerGasTurbineController(this, entityPlayer);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiGasTurbine((ContainerGasTurbineController)menu);
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockGasTurbine.gas_turbine_controller;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.gasTurbine.getBlock(this.getTeBlock());
    }

    @Override
    public void updateTileServer(Player var1, double var2) {
        this.work = !this.work;
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ISocket.class);
        this.energy = (ISocket)this.getWorld().getBlockEntity(pos1.get(0));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IRecuperator.class);
        for (BlockPos pos : pos1) {
            this.recuperators.add((IRecuperator)this.getWorld().getBlockEntity(pos));
        }
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), ITank.class);
        this.tank = (ITank)this.getWorld().getBlockEntity(pos1.get(0));
        this.posesBearings = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IAirBearings.class);
    }

    public void spawnExhaustParticles(Level level) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        List<BlockPos> exhausts = this.posesBearings;
        for (BlockPos pos : exhausts) {
            double x = (double)pos.getX() + 0.5;
            double y = (double)pos.getY() + 0.5;
            double z = (double)pos.getZ() + 0.5;
            Vec3 motion = Vec3.atLowerCornerOf((Vec3i)this.getFacing().getOpposite().getNormal());
            server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0, motion.x, motion.y, motion.z, 0.2);
        }
    }

    @Override
    public void setFull(boolean full) {
        super.setFull(full);
        if (!full) {
            this.energy = null;
            this.recuperators.clear();
            this.tank = null;
        }
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void init() {
        gasMapValue.put((Fluid)FluidName.fluidgas.getInstance().get(), 250);
        gasMapValue.put((Fluid)FluidName.fluidmethane.getInstance().get(), 140);
        gasMapValue.put((Fluid)FluidName.fluidpropane.getInstance().get(), 65);
        gasMapValue.put((Fluid)FluidName.fluidacetylene.getInstance().get(), 10);
        gasMapValue.put((Fluid)FluidName.fluidethylene.getInstance().get(), 40);
        gasMapValue.put((Fluid)FluidName.fluidethane.getInstance().get(), 52);
        gasMapValue.put((Fluid)FluidName.fluidbenzene.getInstance().get(), 35);
        gasMapValue.put((Fluid)FluidName.fluidcyclohexane.getInstance().get(), 70);
        gasMapValue.put((Fluid)FluidName.fluidbiogas.getInstance().get(), 15);
        gasMapValue.put((Fluid)FluidName.fluidpropylene.getInstance().get(), 70);
        gasMapValue.put((Fluid)FluidName.fluidbutadiene.getInstance().get(), 110);
        gasMapValue.put((Fluid)FluidName.fluidbutene.getInstance().get(), 120);
        gasMapValue.put((Fluid)FluidName.fluidtertbutylmethylether.getInstance().get(), 250);
    }
}

