/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.bee;

import com.denfop.api.bee.IBee;
import com.denfop.tiles.bee.EnumTypeBee;
import com.denfop.tiles.bee.EnumTypeLife;
import com.denfop.world.WorldBaseGen;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public class Bee {
    public static final Codec<Bee> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.fieldOf("id").forGetter(Bee::getId), (App)Codec.INT.fieldOf("maxLife").forGetter(Bee::getMaxLife), (App)Codec.INT.fieldOf("birthTick").forGetter(Bee::getBirthTick), (App)Codec.DOUBLE.fieldOf("jelly").forGetter(Bee::getJelly), (App)Codec.DOUBLE.fieldOf("food").forGetter(Bee::getFood), (App)Codec.BOOL.fieldOf("ill").forGetter(Bee::isIll), (App)Codec.INT.fieldOf("tick").forGetter(Bee::getTick), (App)Codec.STRING.xmap(EnumTypeBee::valueOf, Enum::name).fieldOf("typeBee").forGetter(Bee::getTypeBee), (App)Codec.STRING.xmap(EnumTypeLife::valueOf, Enum::name).fieldOf("type").forGetter(Bee::getType), (App)Codec.BOOL.fieldOf("isDead").forGetter(Bee::isDead), (App)Codec.BOOL.fieldOf("wasBirth").forGetter(Bee::isWasBirth)).apply((Applicative)instance, Bee::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, Bee> STREAM_CODEC = StreamCodec.of((buf, value) -> {
        buf.writeLong(value.getId());
        buf.writeInt(value.getMaxLife());
        buf.writeInt(value.getBirthTick());
        buf.writeDouble(value.getJelly());
        buf.writeDouble(value.getFood());
        buf.writeBoolean(value.isIll());
        buf.writeInt(value.getTick());
        buf.writeUtf(value.getTypeBee().name());
        buf.writeUtf(value.getType().name());
        buf.writeBoolean(value.isDead());
        buf.writeBoolean(value.isWasBirth());
    }, buf -> new Bee(buf.readLong(), buf.readInt(), buf.readInt(), buf.readDouble(), buf.readDouble(), buf.readBoolean(), buf.readInt(), EnumTypeBee.valueOf(buf.readUtf()), EnumTypeLife.valueOf(buf.readUtf()), buf.readBoolean(), buf.readBoolean()));
    final long id;
    private final int maxLife;
    private final int birthTick;
    private double jelly;
    private double food;
    private boolean ill;
    private int tick;
    private EnumTypeBee typeBee;
    private EnumTypeLife type;
    private boolean isDead;
    private boolean wasBirth = false;

    public Bee(EnumTypeBee typeBee, IBee bee, EnumTypeLife type, double food, int tick) {
        this.maxLife = bee.getTickLifecycles();
        this.typeBee = typeBee;
        this.type = type;
        this.id = WorldBaseGen.random.nextLong();
        this.birthTick = bee.getTickBirthRate();
        this.tick = tick;
        this.wasBirth = this.isChild();
        this.jelly = 0.0;
        this.ill = false;
        this.food = food;
    }

    public Bee(long id, int maxLife, int birthTick, double jelly, double food, boolean isIll, int tick, EnumTypeBee enumTypeBee, EnumTypeLife enumTypeLife, boolean isDead, boolean isWasBirth) {
        this.maxLife = maxLife;
        this.typeBee = enumTypeBee;
        this.type = enumTypeLife;
        this.id = id;
        this.birthTick = birthTick;
        this.tick = tick;
        this.wasBirth = isWasBirth;
        this.jelly = jelly;
        this.ill = isIll;
        this.isDead = isDead;
        this.food = food;
    }

    public Bee(CompoundTag tagCompound) {
        this.maxLife = tagCompound.getShort("maxLife");
        this.ill = tagCompound.getBoolean("ill");
        this.typeBee = EnumTypeBee.values()[tagCompound.getByte("typeBee")];
        this.type = EnumTypeLife.values()[tagCompound.getByte("type")];
        this.id = WorldBaseGen.random.nextLong();
        this.birthTick = tagCompound.getShort("birthTick");
        this.tick = tagCompound.getShort("tick");
        this.jelly = (double)tagCompound.getShort("jelly") / 100.0;
        this.food = (double)tagCompound.getShort("food") / 100.0;
    }

    public long getId() {
        return this.id;
    }

    public int getBirthTick() {
        return this.birthTick;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bee bee = (Bee)o;
        return this.id == bee.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public CompoundTag writeToNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.putShort("maxLife", (short)this.maxLife);
        tagCompound.putByte("type", (byte)this.type.ordinal());
        tagCompound.putByte("typeBee", (byte)this.typeBee.ordinal());
        tagCompound.putBoolean("ill", this.ill);
        tagCompound.putShort("birthTick", (short)this.birthTick);
        tagCompound.putShort("tick", (short)this.tick);
        tagCompound.putShort("jelly", (short)(this.jelly * 100.0));
        tagCompound.putShort("food", (short)(this.food * 100.0));
        return tagCompound;
    }

    public boolean isWasBirth() {
        return this.wasBirth;
    }

    public boolean isChild() {
        return this.tick < this.birthTick;
    }

    public void addTick(int tick, double lifeGenome) {
        this.tick += tick;
        if (!this.isDead) {
            this.isDead = (double)this.tick > (double)this.maxLife * lifeGenome;
        }
    }

    public void addFood(double food) {
        this.food += food;
    }

    public void addJelly(double jelly) {
        this.jelly += jelly;
    }

    public void removeFood() {
        this.food -= 0.25 + 0.25 * (double)(this.isIll() ? 1 : 0);
        if (this.food <= 0.0) {
            this.food = 0.0;
            this.isDead = true;
        }
    }

    public void removeJelly() {
        this.jelly -= 0.1 + 0.1 * (double)(this.isIll() ? 1 : 0);
        if (this.jelly <= 0.0) {
            this.jelly = 0.0;
            this.isDead = true;
        }
    }

    public double getJelly() {
        return this.jelly;
    }

    public double getFood() {
        return this.food;
    }

    public boolean isDead() {
        return this.isDead;
    }

    public void setDead(boolean b) {
        this.isDead = b;
    }

    public boolean isIll() {
        return this.ill;
    }

    public void setIll(boolean ill) {
        this.ill = ill;
    }

    public int getTick() {
        return this.tick;
    }

    public int getMaxLife() {
        return this.maxLife;
    }

    public EnumTypeLife getType() {
        return this.type;
    }

    public void setType(EnumTypeLife type) {
        this.type = type;
    }

    public EnumTypeBee getTypeBee() {
        return this.typeBee;
    }

    public void setTypeBee(EnumTypeBee typeBee) {
        this.typeBee = typeBee;
    }
}

