/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.base;

import com.denfop.Localization;
import com.denfop.api.recipe.IUpdateTick;
import com.denfop.api.recipe.InvSlotRecipes;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.api.upgrades.IUpgradableBlock;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.audio.EnumSound;
import com.denfop.componets.ComponentProcess;
import com.denfop.componets.ComponentProgress;
import com.denfop.componets.ComponentUpgrade;
import com.denfop.componets.ComponentUpgradeSlots;
import com.denfop.componets.Energy;
import com.denfop.componets.TypeUpgrade;
import com.denfop.container.ContainerTripleElectricMachine;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDischarge;
import com.denfop.invslot.InvSlotUpgrade;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.tiles.base.EnumTripleElectricMachine;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.base.TileStandartMachine;
import com.denfop.utils.Keyboard;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public abstract class TileTripleElectricMachine
extends TileStandartMachine
implements IUpgradableBlock,
IUpdateTick {
    public final InvSlotDischarge dischargeSlot;
    public final InvSlotRecipes inputSlotA;
    public final InvSlotUpgrade upgradeSlot = new InvSlotUpgrade(this, 4);
    public final ComponentUpgradeSlots componentUpgrade;
    public final ComponentProgress componentProgress;
    public final ComponentProcess componentProcess;
    protected final String name;
    protected final EnumTripleElectricMachine type;
    private final ComponentUpgrade componentUpgrades;
    public double energyConsume;
    public int operationLength;
    public int operationsPerTick;
    public MachineRecipe output;
    protected boolean sound = true;

    public TileTripleElectricMachine(int energyPerTick, int length, int outputSlots, String name, EnumTripleElectricMachine type, IMultiTileBlock block, BlockPos pos, BlockState state) {
        super(outputSlots, block, pos, state);
        this.name = name;
        this.inputSlotA = new InvSlotRecipes((TileEntityInventory)this, type.recipe_name, (IUpdateTick)this);
        this.type = type;
        this.dischargeSlot = new InvSlotDischarge(this, InvSlot.TypeItemSlot.INPUT, 1, false);
        this.componentUpgrade = this.addComponent(new ComponentUpgradeSlots(this, this.upgradeSlot));
        this.componentProgress = this.addComponent(new ComponentProgress((TileEntityInventory)this, 1, (short)length));
        this.componentProcess = this.addComponent(new ComponentProcess(this, length, energyPerTick));
        this.componentProcess.setHasAudio(true);
        this.componentProcess.setSlotOutput(this.outputSlot);
        this.componentProcess.setInvSlotRecipes(this.inputSlotA);
        this.energy = this.addComponent(Energy.asBasicSink((TileEntityInventory)this, (double)energyPerTick * (double)length, 1).addManagedSlot(this.dischargeSlot));
        this.componentUpgrades = this.addComponent(new ComponentUpgrade(this, TypeUpgrade.INSTANT, TypeUpgrade.STACK));
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        if (this.type == EnumTripleElectricMachine.ADV_ALLOY_SMELTER) {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.heatmachine.info"));
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
            }
        } else {
            if (!Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("press.lshift"));
            }
            if (Keyboard.isKeyDown(340)) {
                tooltip.add(Localization.translate("iu.machines_work_energy") + this.componentProcess.getEnergyConsume() + Localization.translate("iu.machines_work_energy_type_eu"));
                tooltip.add(Localization.translate("iu.machines_work_length") + this.componentProcess.getOperationsPerTick());
            }
        }
        if (this.getComp(Energy.class) != null) {
            Energy energy = this.getComp(Energy.class);
            if (!energy.getSourceDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSourceTier()));
            } else if (!energy.getSinkDirs().isEmpty()) {
                tooltip.add(Localization.translate("iu.item.tooltip.PowerTier", energy.getSinkTier()));
            }
        }
    }

    @Override
    public void onUpdate() {
    }

    @Override
    public MachineRecipe getRecipeOutput() {
        return this.output;
    }

    @Override
    public void setRecipeOutput(MachineRecipe output) {
        this.output = output;
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.getBoolean("sound");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("sound", this.sound);
        return nbttagcompound;
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            this.inputSlotA.load();
            this.getOutput();
        }
    }

    public MachineRecipe getOutput() {
        this.output = this.inputSlotA.process();
        return this.output;
    }

    public ContainerTripleElectricMachine getGuiContainer(Player entityPlayer) {
        return new ContainerTripleElectricMachine(entityPlayer, this, this.type);
    }

    @Override
    public Set<UpgradableProperty> getUpgradableProperties() {
        return EnumSet.of(UpgradableProperty.Processing, UpgradableProperty.Transformer, UpgradableProperty.EnergyStorage, UpgradableProperty.ItemExtract, UpgradableProperty.ItemInput);
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.getBlockPos(), this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.getBlockPos());
            this.getWorld().playSound(null, this.getBlockPos(), EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.getBlockPos());
        }
    }

    @Override
    public final float getChargeLevel() {
        return Math.min((float)this.energy.getEnergy() / (float)this.energy.getCapacity(), 1.0f);
    }

    public String getInventoryName() {
        return this.name;
    }
}

