/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.tiles.adv_cokeoven;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.audio.EnumTypeAudio;
import com.denfop.api.audio.IAudioFixer;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.multiblock.IMainMultiBlock;
import com.denfop.api.recipe.InvSlotOutput;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.audio.EnumSound;
import com.denfop.blocks.BlockTileEntity;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockAdvCokeOven;
import com.denfop.componets.AirPollutionComponent;
import com.denfop.componets.HeatComponent;
import com.denfop.componets.SoilPollutionComponent;
import com.denfop.container.ContainerAdvCokeOven;
import com.denfop.container.ContainerBase;
import com.denfop.gui.GuiAdvCokeOven;
import com.denfop.gui.GuiCore;
import com.denfop.invslot.InvSlot;
import com.denfop.invslot.InvSlotDrainTank;
import com.denfop.invslot.InvSlotFluid;
import com.denfop.invslot.InvSlotFluidByList;
import com.denfop.network.DecoderHandler;
import com.denfop.network.EncoderHandler;
import com.denfop.network.IUpdatableTileEvent;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketStopSound;
import com.denfop.network.packet.PacketUpdateFieldTile;
import com.denfop.register.InitMultiBlockSystem;
import com.denfop.tiles.adv_cokeoven.IHeat;
import com.denfop.tiles.adv_cokeoven.IInputFluid;
import com.denfop.tiles.adv_cokeoven.IMain;
import com.denfop.tiles.adv_cokeoven.IOutputFluid;
import com.denfop.tiles.adv_cokeoven.InvSlotCokeOven;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.tiles.mechanism.multiblocks.base.TileMultiBlockBase;
import com.denfop.utils.FluidHandlerFix;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.IFluidTank;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import org.apache.commons.lang3.mutable.MutableObject;

public class TileCokeOvenMain
extends TileMultiBlockBase
implements IMain,
IUpdatableTileEvent,
IAudioFixer {
    public final InvSlotDrainTank fluidSlot1;
    public final InvSlotOutput output2;
    public final InvSlotOutput output1;
    public final InvSlotFluidByList fluidSlot;
    public final HeatComponent heat;
    private final SoilPollutionComponent pollutionSoil;
    private final AirPollutionComponent pollutionAir;
    public FluidTank tank = null;
    public boolean load = false;
    public InvSlotCokeOven invSlotBlastFurnace = new InvSlotCokeOven(this);
    public InvSlotOutput output = new InvSlotOutput(this, 1);
    public FluidTank tank1 = null;
    public IHeat blastHeat;
    public IInputFluid blastInputFluid;
    public IOutputFluid blastOutputFluid;
    public List<Player> entityPlayerList;
    public double progress = 0.0;
    public int bar = 1;
    public EnumTypeAudio typeAudio = EnumTypeAudio.OFF;
    public EnumTypeAudio[] valuesAudio = EnumTypeAudio.values();
    private boolean sound = true;

    public TileCokeOvenMain(BlockPos pos, BlockState state) {
        super(InitMultiBlockSystem.advCokeOvenMultiBlock, BlockAdvCokeOven.adv_coke_oven_main, pos, state);
        this.full = false;
        this.entityPlayerList = new ArrayList<Player>();
        this.fluidSlot = new InvSlotFluidByList((TileEntityInventory)this, 1, (Fluid)FluidName.fluidsteam.getInstance().get());
        this.fluidSlot1 = new InvSlotDrainTank(this, InvSlot.TypeItemSlot.INPUT, 1, InvSlotFluid.TypeFluidSlot.OUTPUT, (Fluid)FluidName.fluidcreosote.getInstance().get());
        this.output1 = new InvSlotOutput(this, 1);
        this.output2 = new InvSlotOutput(this, 1);
        this.heat = this.addComponent(HeatComponent.asBasicSink(this, 1000.0));
        this.pollutionSoil = this.addComponent(new SoilPollutionComponent(this, 0.2));
        this.pollutionAir = this.addComponent(new AirPollutionComponent(this, 0.5));
    }

    @Override
    public IMultiTileBlock getTeBlock() {
        return BlockAdvCokeOven.adv_coke_oven_main;
    }

    @Override
    public BlockTileEntity getBlock() {
        return IUItem.adv_cokeoven.getBlock(this.getTeBlock().getId());
    }

    @Override
    public void readContainerPacket(CustomPacketBuffer customPacketBuffer) {
        super.readContainerPacket(customPacketBuffer);
        try {
            this.full = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.tank = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.tank1 = (FluidTank)DecoderHandler.decode(customPacketBuffer);
            this.progress = (Double)DecoderHandler.decode(customPacketBuffer);
            this.bar = (Integer)DecoderHandler.decode(customPacketBuffer);
            this.sound = (Boolean)DecoderHandler.decode(customPacketBuffer);
            this.heat.buffer.storage = (Double)DecoderHandler.decode(customPacketBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CustomPacketBuffer writeContainerPacket() {
        CustomPacketBuffer packet = super.writeContainerPacket();
        try {
            EncoderHandler.encode(packet, this.full);
            EncoderHandler.encode(packet, this.tank);
            EncoderHandler.encode(packet, this.tank1);
            EncoderHandler.encode(packet, this.progress);
            EncoderHandler.encode(packet, this.bar);
            EncoderHandler.encode(packet, this.sound);
            EncoderHandler.encode(packet, this.heat.buffer.storage);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return packet;
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        tooltip.add(Localization.translate("iu.blastfurnace.info5") + new ItemStack((ItemLike)IUItem.ForgeHammer.getItem()).getDisplayName().getString());
    }

    @Override
    public EnumTypeAudio getTypeAudio() {
        return this.typeAudio;
    }

    @Override
    public void setType(EnumTypeAudio type) {
        this.typeAudio = type;
    }

    @Override
    public boolean getEnable() {
        return this.sound;
    }

    @Override
    public SoundEvent getSound() {
        return EnumSound.blast_furnace.getSoundEvent();
    }

    @Override
    public void initiate(int soundEvent) {
        if (this.getTypeAudio() == this.valuesAudio[soundEvent % this.valuesAudio.length]) {
            return;
        }
        this.setType(this.valuesAudio[soundEvent % this.valuesAudio.length]);
        if (!this.getEnable()) {
            return;
        }
        if (this.getSound() == null) {
            return;
        }
        if (soundEvent == 0) {
            this.getWorld().playSound(null, this.pos, this.getSound(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else if (soundEvent == 1) {
            new PacketStopSound(this.getWorld(), this.pos);
            this.getWorld().playSound(null, this.pos, EnumSound.InterruptOne.getSoundEvent(), SoundSource.BLOCKS, 1.0f, 1.0f);
        } else {
            new PacketStopSound(this.getWorld(), this.pos);
        }
    }

    @Override
    public void updateAfterAssembly() {
        List<BlockPos> pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IInputFluid.class);
        this.setInputFluid((IInputFluid)this.getWorld().getBlockEntity(pos1.get(0)));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IOutputFluid.class);
        this.setOutputFluid((IOutputFluid)this.getWorld().getBlockEntity(pos1.get(0)));
        pos1 = this.getMultiBlockStucture().getPosFromClass(this.getFacing(), this.getBlockPos(), IHeat.class);
        this.setHeat((IHeat)this.getWorld().getBlockEntity(pos1.get(0)));
    }

    @Override
    public void usingBeforeGUI() {
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        if (!this.getWorld().isClientSide) {
            new PacketUpdateFieldTile(this, "sound", this.sound);
        }
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (!this.full) {
            if (this.getActive()) {
                this.setActive(false);
                this.initiate(2);
            }
            return;
        }
        MutableObject output1 = new MutableObject();
        if (this.fluidSlot.transferToTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, true) && (output1.getValue() == null || this.output1.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot.transferToTank((IFluidTank)this.tank, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output1.add((ItemStack)output1.getValue());
            }
        }
        if (this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)(output1 = new MutableObject()), true) && (output1.getValue() == null || this.output2.canAdd((ItemStack)output1.getValue()))) {
            this.fluidSlot1.transferFromTank((IFluidTank)this.tank1, (MutableObject<ItemStack>)output1, false);
            if (output1.getValue() != null) {
                this.output2.add((ItemStack)output1.getValue());
            }
        }
        if (this.heat.getEnergy() > 500.0 && !this.invSlotBlastFurnace.isEmpty() && this.tank1 != null && this.tank1.getFluidAmount() + 500 <= this.tank1.getCapacity()) {
            int amount_stream = this.tank.getFluidAmount();
            if (this.heat.getEnergy() == this.heat.getCapacity() && this.tank.getFluidAmount() > 0) {
                int bar1 = this.bar;
                if (amount_stream < bar1) {
                    bar1 = amount_stream;
                }
                if (bar1 > 0) {
                    if (this.progress == 0.0) {
                        this.setActive(true);
                        this.initiate(0);
                    }
                    if (!this.getActive()) {
                        this.setActive(true);
                    }
                    this.progress += 1.0 + 0.5 * (double)(bar1 - 1);
                    this.tank.drain(Math.min(bar1, this.tank.getFluidAmount()), IFluidHandler.FluidAction.EXECUTE);
                    if (this.progress >= 2340.0) {
                        this.progress = 0.0;
                        this.invSlotBlastFurnace.get(0).shrink(1);
                        this.setActive(false);
                        this.tank1.fill(new FluidStack((Fluid)FluidName.fluidcreosote.getInstance().get(), 500), IFluidHandler.FluidAction.EXECUTE);
                        this.initiate(2);
                    }
                }
            }
        } else if (this.getActive()) {
            this.setActive(false);
        }
        if (this.heat.getEnergy() > 0.0) {
            this.heat.useEnergy(1.0);
        }
    }

    @Override
    public IHeat getHeat() {
        return this.blastHeat;
    }

    @Override
    public void setHeat(IHeat blastHeat) {
        this.blastHeat = blastHeat;
        try {
            this.heat.onUnloaded();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.blastHeat != null) {
            this.heat.setParent((TileEntityInventory)((Object)blastHeat));
            this.heat.onLoaded();
        }
    }

    @Override
    public IInputFluid getInputFluid() {
        return this.blastInputFluid;
    }

    @Override
    public void setInputFluid(IInputFluid blastInputFluid) {
        this.blastInputFluid = blastInputFluid;
        this.tank = this.blastInputFluid == null ? null : this.blastInputFluid.getFluidTank();
    }

    @Override
    public IOutputFluid getOutputFluid() {
        return this.blastOutputFluid;
    }

    @Override
    public void setOutputFluid(IOutputFluid blastInputFluid) {
        this.blastOutputFluid = blastInputFluid;
        this.tank1 = this.blastOutputFluid == null ? null : this.blastOutputFluid.getFluidTank();
    }

    @Override
    public void readFromNBT(CompoundTag nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.sound = nbttagcompound.getBoolean("sound");
        this.bar = nbttagcompound.getInt("bar");
    }

    @Override
    public CompoundTag writeToNBT(CompoundTag nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.putBoolean("sound", this.sound);
        nbttagcompound.putInt("bar", this.bar);
        return nbttagcompound;
    }

    @Override
    public double getProgress() {
        return this.progress;
    }

    @Override
    public void updateTileServer(Player entityPlayer, double i) {
        switch ((int)i) {
            case 0: {
                this.bar = Math.min(this.bar + 1, 5);
                break;
            }
            case 1: {
                this.bar = Math.max(1, this.bar - 1);
                break;
            }
            case 10: {
                this.sound = !this.sound;
                new PacketUpdateFieldTile(this, "sound", this.sound);
                if (this.sound || this.getTypeAudio() != EnumTypeAudio.ON) break;
                this.setType(EnumTypeAudio.OFF);
                this.initiate(2);
            }
        }
    }

    @Override
    public void updateField(String name, CustomPacketBuffer is) {
        if (name.equals("sound")) {
            try {
                this.sound = (Boolean)DecoderHandler.decode(is);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        super.updateField(name, is);
    }

    @Override
    public boolean onActivated(Player player, InteractionHand hand, Direction side, Vec3 vec3) {
        if (this.getWorld().isClientSide) {
            return false;
        }
        if (this.full && this.activate && !this.getWorld().isClientSide && FluidHandlerFix.getFluidHandler(player.getItemInHand(hand)) != null) {
            return ModUtils.interactWithFluidHandler(player, hand, (IFluidHandler)this.level.getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), (Object)side));
        }
        return super.onActivated(player, hand, side, vec3);
    }

    public ContainerAdvCokeOven getGuiContainer(Player entityPlayer) {
        if (!this.entityPlayerList.contains(entityPlayer)) {
            this.entityPlayerList.add(entityPlayer);
        }
        return new ContainerAdvCokeOven(entityPlayer, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<? extends IAdvInventory>> getGui(Player var1, ContainerBase<? extends IAdvInventory> menu) {
        return new GuiAdvCokeOven((ContainerAdvCokeOven)menu);
    }

    @Override
    public IMainMultiBlock getMain() {
        return this;
    }

    @Override
    public void setMainMultiElement(IMainMultiBlock main) {
    }

    @Override
    public boolean isMain() {
        return true;
    }

    @Override
    public void onNetworkEvent(int var1) {
    }
}

