/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.windgenerator;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.entity.Entity;

public class RotorModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart rotor1;
    private final ModelPart rotor2;
    private final ModelPart rotor3;
    private final ModelPart rotor4;

    public RotorModel(int radius) {
        super(RenderType::entityCutoutNoCull);
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        this.rotor1 = root.addOrReplaceChild("rotor1", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, (float)(radius * 8), 8.0f).mirror(), PartPose.rotation((float)0.0f, (float)-0.5f, (float)0.0f)).bake(32, 256);
        this.rotor2 = root.addOrReplaceChild("rotor2", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, (float)(radius * 8), 8.0f).mirror(), PartPose.rotation((float)3.1f, (float)0.5f, (float)0.0f)).bake(32, 256);
        this.rotor3 = root.addOrReplaceChild("rotor3", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, (float)(radius * 8), 8.0f).mirror(), PartPose.rotation((float)4.7f, (float)0.0f, (float)0.5f)).bake(32, 256);
        this.rotor4 = root.addOrReplaceChild("rotor4", CubeListBuilder.create().texOffs(0, 0).addBox(0.0f, 0.0f, -4.0f, 1.0f, (float)(radius * 8), 8.0f).mirror(), PartPose.rotation((float)1.5f, (float)0.0f, (float)-0.5f)).bake(32, 256);
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int color) {
        this.rotor1.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rotor2.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rotor3.render(poseStack, buffer, packedLight, packedOverlay, color);
        this.rotor4.render(poseStack, buffer, packedLight, packedOverlay, color);
    }
}

