/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.panel;

import com.denfop.api.solar.EnumTypeParts;
import com.denfop.api.solar.ISolarItem;
import com.denfop.render.panel.BottomModel;
import com.denfop.render.panel.ModelMiniPanelGlass;
import com.denfop.tiles.panels.entity.TileEntityMiniPanels;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class TileEntityMiniPanelRender
implements BlockEntityRenderer<TileEntityMiniPanels> {
    private static final Map<Integer, ModelMiniPanelGlass> panelModels = new HashMap<Integer, ModelMiniPanelGlass>();
    private static final Map<Integer, BottomModel> bottomModels = new HashMap<Integer, BottomModel>();
    private static final ResourceLocation bottomTextures = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/block/admsp_bottom.png");
    private static final ModelMiniPanelGlass bonusPanel = new ModelMiniPanelGlass(10);
    private static final BottomModel bonusBottom = new BottomModel(10);

    public TileEntityMiniPanelRender(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileEntityMiniPanels te, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        poseStack.pushPose();
        panelModels.clear();
        if (te.getBonus(EnumTypeParts.GENERATION) == 0.0) {
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = te.invSlotGlass.get(i);
                if (stack.isEmpty()) continue;
                ModelMiniPanelGlass model = panelModels.computeIfAbsent(i, ModelMiniPanelGlass::new);
                BottomModel model1 = bottomModels.computeIfAbsent(i, BottomModel::new);
                ResourceLocation glassTexture = ((ISolarItem)stack.getItem()).getResourceLocation(0);
                VertexConsumer glassConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)glassTexture));
                model.renderToBuffer(poseStack, glassConsumer, packedLight, packedOverlay, -1);
                VertexConsumer bottomConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)bottomTextures));
                model1.renderToBuffer(poseStack, bottomConsumer, packedLight, packedOverlay, -1);
            }
        } else {
            ItemStack stack = te.invSlotGlass.get(0);
            ResourceLocation glassTexture = ((ISolarItem)stack.getItem()).getResourceLocation(stack.getDamageValue());
            VertexConsumer glassConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)glassTexture));
            bonusPanel.renderToBuffer(poseStack, glassConsumer, packedLight, packedOverlay, -1);
            VertexConsumer bottomConsumer = bufferSource.getBuffer(RenderType.entitySolid((ResourceLocation)bottomTextures));
            bonusBottom.renderToBuffer(poseStack, bottomConsumer, packedLight, packedOverlay, -1);
        }
        poseStack.popPose();
    }
}

