/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.panel;

import com.denfop.render.panel.ModelCord;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashSet;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PollutionModel<T extends Entity>
extends EntityModel<T> {
    private final ModelPart pollution;

    public PollutionModel(RandomSource random, int index) {
        super(RenderType::entityCutoutNoCull);
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition root = mesh.getRoot();
        HashSet<ModelCord> set = new HashSet<ModelCord>();
        int maxIterations = switch (index) {
            case 1 -> 64;
            case 2 -> 128;
            case -1, 3 -> 192;
            default -> 0;
        };
        int i = 0;
        while (i < maxIterations) {
            int z;
            int x = random.nextInt(16);
            ModelCord cord = new ModelCord(x, z = random.nextInt(16));
            if (!set.add(cord)) continue;
            root.addOrReplaceChild("box" + i, CubeListBuilder.create().texOffs(0, 0).addBox((float)x, 16.1f, (float)z, 1.0f, 0.0f, 1.0f), PartPose.ZERO);
            ++i;
        }
        this.pollution = LayerDefinition.create((MeshDefinition)mesh, (int)0, (int)0).bakeRoot();
    }

    public void setupAnim(T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
    }

    public void renderToBuffer(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, int col) {
        this.pollution.render(poseStack, buffer, packedLight, packedOverlay, col);
    }
}

