/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.render.fluidintegrator;

import com.denfop.render.RenderFluidBlock;
import com.denfop.tiles.mechanism.TileEntityPrimalFluidIntegrator;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class PrimalFluidIntegratorRenderer
implements BlockEntityRenderer<TileEntityPrimalFluidIntegrator> {
    private final ItemRenderer itemRenderer;
    private final BlockEntityRendererProvider.Context contex;
    private float rotation = 0.0f;
    private float prevRotation = 0.0f;

    public PrimalFluidIntegratorRenderer(BlockEntityRendererProvider.Context p_173636_) {
        this.contex = p_173636_;
        this.itemRenderer = Minecraft.getInstance().getItemRenderer();
    }

    public void render(TileEntityPrimalFluidIntegrator tile, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        ItemStack outputStack;
        BlockHitResult blockHit;
        this.renderTanks(tile, poseStack, bufferSource, packedLight, packedOverlay);
        ItemStack itemStack = tile.inputSlotA.get(0);
        if (!itemStack.isEmpty()) {
            poseStack.pushPose();
            float scale = Math.min(1.0f, (float)tile.fluidTank1.getFluidAmount() / (float)tile.fluidTank1.getCapacity());
            Vec3 offset = this.getOffset(tile.getFacing(), scale);
            poseStack.translate(offset.x, offset.y, offset.z);
            if (scale > 0.1f) {
                poseStack.mulPose(Axis.XP.rotationDegrees(this.rotation));
                poseStack.mulPose(Axis.YP.rotationDegrees(this.rotation));
                poseStack.mulPose(Axis.ZP.rotationDegrees(this.rotation));
            } else {
                poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            }
            poseStack.scale(0.9f, 0.9f, 0.9f);
            this.itemRenderer.renderStatic(itemStack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, tile.getLevel(), 0);
            poseStack.popPose();
        }
        BlockPos cameraPos = tile.getBlockPos();
        HitResult hitResult = Minecraft.getInstance().hitResult;
        if (hitResult instanceof BlockHitResult && (cameraPos.equals((Object)(blockHit = (BlockHitResult)hitResult).getBlockPos()) || cameraPos.above().equals((Object)blockHit.getBlockPos()))) {
            String text = (int)(tile.getProgress() * 100.0) + "%";
            poseStack.pushPose();
            poseStack.translate(0.5, 1.5, 0.5);
            MutableComponent text1 = Component.literal((String)text);
            this.renderFloatingText((Component)text1, poseStack, bufferSource, packedLight);
            poseStack.translate(0.0, -0.25, 0.0);
            poseStack.popPose();
        }
        if (!(outputStack = tile.outputSlot.get(0)).isEmpty()) {
            poseStack.pushPose();
            Vec3 outputOffset = this.getOutputOffset(tile.getFacing());
            poseStack.translate(outputOffset.x, outputOffset.y, outputOffset.z);
            poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(outputStack, ItemDisplayContext.GROUND, packedLight, packedOverlay, poseStack, bufferSource, tile.getLevel(), 0);
            poseStack.popPose();
        }
        this.prevRotation = this.rotation = this.prevRotation + (this.rotation - this.prevRotation) * partialTicks;
        this.rotation += 0.25f;
    }

    private void renderTanks(TileEntityPrimalFluidIntegrator tile, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        float scale;
        if (!tile.fluidTank1.getFluid().isEmpty()) {
            poseStack.pushPose();
            scale = (float)tile.fluidTank1.getFluidAmount() * 0.75f / (float)tile.fluidTank1.getCapacity();
            switch (tile.facing) {
                case 2: {
                    poseStack.translate(0.63, 0.3, 0.38);
                    break;
                }
                case 3: {
                    poseStack.translate(0.13, 0.3, 0.38);
                    break;
                }
                case 4: {
                    poseStack.translate(0.38, 0.3, 0.131);
                    break;
                }
                case 5: {
                    poseStack.translate(0.38, 0.3, 0.63);
                }
            }
            RenderFluidBlock.renderFluid(tile.fluidTank1.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.62f);
            poseStack.popPose();
        }
        if (!tile.fluidTank2.getFluid().isEmpty()) {
            poseStack.pushPose();
            scale = (float)tile.fluidTank2.getFluidAmount() * 0.7f / (float)tile.fluidTank2.getCapacity();
            switch (tile.facing) {
                case 2: {
                    poseStack.translate(0.010000000000000009, 0.15, 0.51);
                    break;
                }
                case 3: {
                    poseStack.translate(1.01, 0.15, 0.51);
                    break;
                }
                case 4: {
                    poseStack.translate(0.51, 0.15, 1.01);
                    break;
                }
                case 5: {
                    poseStack.translate(0.51, 0.15, 0.010000000000000009);
                }
            }
            RenderFluidBlock.renderFluid(tile.fluidTank2.getFluid(), bufferSource, tile.getLevel(), tile.getPos(), poseStack, scale, 0.49f, 1);
            poseStack.popPose();
        }
    }

    private void renderFloatingText(Component text, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        boolean flag = true;
        boolean i = false;
        poseStack.pushPose();
        poseStack.translate(0.0f, 0.0f, 0.0f);
        poseStack.mulPose(Minecraft.getInstance().getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(0.025f, -0.025f, 0.025f);
        Matrix4f matrix4f = poseStack.last().pose();
        float f = Minecraft.getInstance().options.getBackgroundOpacity(0.25f);
        int j = (int)(f * 255.0f) << 24;
        Font font = Minecraft.getInstance().font;
        float f1 = -font.width((FormattedText)text) / 2;
        font.drawInBatch(text, f1, (float)i, 0x20FFFFFF, false, matrix4f, buffer, Font.DisplayMode.SEE_THROUGH, j, packedLight);
        if (flag) {
            font.drawInBatch(text, f1, (float)i, -1, false, matrix4f, buffer, Font.DisplayMode.NORMAL, 0, packedLight);
        }
        poseStack.popPose();
    }

    private Vec3 getOffset(Direction facing, float scale) {
        return switch (facing) {
            case Direction.SOUTH -> new Vec3(0.2, 0.3 + 0.6 * (double)scale, 0.5);
            case Direction.NORTH -> new Vec3(0.75, 0.3 + 0.6 * (double)scale, 0.5);
            case Direction.WEST -> new Vec3(0.5, 0.3 + 0.6 * (double)scale, 0.2);
            case Direction.EAST -> new Vec3(0.5, 0.3 + 0.6 * (double)scale, 0.75);
            default -> Vec3.ZERO;
        };
    }

    private Vec3 getOutputOffset(Direction facing) {
        return switch (facing) {
            case Direction.SOUTH -> new Vec3(1.0, 0.87, 0.5);
            case Direction.NORTH -> new Vec3(0.0, 0.87, 0.5);
            case Direction.WEST -> new Vec3(0.5, 0.87, 0.9);
            case Direction.EAST -> new Vec3(0.5, 0.87, -0.1);
            default -> Vec3.ZERO;
        };
    }
}

