/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.IUCore;
import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import com.denfop.api.recipe.IInputFluid;
import com.denfop.api.recipe.InputFluid;
import com.denfop.api.recipe.RecipeOutput;
import com.denfop.recipe.IInputItemStack;
import com.denfop.recipe.InputFluidStack;
import com.denfop.recipe.InputItemStack;
import com.denfop.recipe.InputOreDict;
import com.denfop.recipe.universalrecipe.SmelteryRecipe;
import com.denfop.tiles.smeltery.TileEntitySmelteryController;
import com.denfop.tiles.smeltery.TileEntitySmelteryFurnace;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class SmelterSerializer
implements RecipeSerializer<SmelteryRecipe> {
    public static LinkedList<Integer> integers = new LinkedList();
    public static final MapCodec<SmelteryRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(builder -> {
        Codec singleInputCodec = RecordCodecBuilder.create(inst -> inst.group((App)Codec.STRING.fieldOf("type").forGetter(i -> i instanceof InputFluidStack ? "fluid" : "item"), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(i -> BuiltInRegistries.ITEM.getKey((Object)i.getInputs().get(0).getItem())), (App)Codec.INT.fieldOf("amount").orElse((Object)1).forGetter(i -> i.getInputs().get(0).getCount())).apply((Applicative)inst, (type, id, amt) -> {
            if ("tag".equals(type)) {
                return new InputOreDict(id.getNamespace() + ":" + id.getPath(), (int)amt);
            }
            if ("fluid".equals(type)) {
                return new InputFluidStack(new FluidStack((Fluid)BuiltInRegistries.FLUID.get(id), amt.intValue()));
            }
            return new InputItemStack(new ItemStack((ItemLike)BuiltInRegistries.ITEM.get(id), amt.intValue()));
        }));
        return builder.group((App)Codec.STRING.fieldOf("operation").forGetter(SmelteryRecipe::getRecipeType), (App)Codec.list((Codec)singleInputCodec).fieldOf("inputs").forGetter(SmelteryRecipe::getInput), (App)Codec.list((Codec)singleInputCodec).fieldOf("outputs").forGetter(SmelteryRecipe::getInput)).apply((Applicative)builder, (operation, inputs, outputs) -> {
            if (!IUCore.register1) {
                ArrayList<FluidStack> fluidStacksInput = new ArrayList<FluidStack>();
                ArrayList<ItemStack> itemStacksInput = new ArrayList<ItemStack>();
                ArrayList<FluidStack> fluidStacksOutput = new ArrayList<FluidStack>();
                ArrayList<ItemStack> itemStacksOutput = new ArrayList<ItemStack>();
                for (IInputItemStack o : inputs) {
                    if (o instanceof InputFluidStack) {
                        fluidStacksInput.add(((InputFluidStack)o).getFluid());
                        continue;
                    }
                    itemStacksInput.add(o.getInputs().get(0));
                }
                for (IInputItemStack o : outputs) {
                    if (o instanceof InputFluidStack) {
                        fluidStacksOutput.add(((InputFluidStack)o).getFluid());
                        continue;
                    }
                    itemStacksOutput.add(o.getInputs().get(0));
                }
                switch (operation) {
                    case "furnace": {
                        ItemStack stack = (ItemStack)itemStacksInput.get(0);
                        FluidStack fluidStack = (FluidStack)fluidStacksOutput.get(0);
                        if (stack == null || fluidStack == null) break;
                        TileEntitySmelteryFurnace.addRecipe("", stack, fluidStack);
                        break;
                    }
                    case "castings_ingot": {
                        ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                        FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                        Recipes.recipes.getRecipeFluid().addRecipe("ingot_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                        break;
                    }
                    case "castings_gear": {
                        ItemStack stack = (ItemStack)itemStacksOutput.get(0);
                        FluidStack fluidStack = (FluidStack)fluidStacksInput.get(0);
                        Recipes.recipes.getRecipeFluid().addRecipe("gear_casting", new BaseFluidMachineRecipe((IInputFluid)new InputFluid(fluidStack), new RecipeOutput(null, stack)));
                        break;
                    }
                    case "mix": {
                        FluidStack fluidStack1 = (FluidStack)fluidStacksOutput.get(0);
                        ArrayList<FluidStack> list = fluidStacksInput;
                        TileEntitySmelteryController.mapRecipes.put(list, fluidStack1);
                    }
                }
                return new SmelteryRecipe("", Collections.emptyList(), ItemStack.EMPTY);
            }
            return new SmelteryRecipe("", Collections.emptyList(), ItemStack.EMPTY);
        });
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipe> STREAM_CODEC = StreamCodec.of(SmelterSerializer::toNetwork, SmelterSerializer::fromNetwork);

    private static SmelteryRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new SmelteryRecipe("", new ArrayList<FluidStack>(), ItemStack.EMPTY);
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, SmelteryRecipe p_320586_) {
    }

    public MapCodec<SmelteryRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SmelteryRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

