/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IPlanet;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.Satellite;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.SatelliteRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class SatelliteSerializer
implements RecipeSerializer<SatelliteRecipe> {
    public static final MapCodec<SatelliteRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(s -> s.name), (App)Codec.STRING.fieldOf("system").forGetter(s -> s.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(s -> s.texturePath), (App)Codec.STRING.xmap(str -> EnumLevels.valueOf(str.toUpperCase()), Enum::name).fieldOf("level").forGetter(s -> s.level), (App)Codec.STRING.fieldOf("planet").forGetter(s -> s.planetName), (App)Codec.INT.fieldOf("temperature").forGetter(s -> s.temperature), (App)Codec.BOOL.fieldOf("pressure").forGetter(s -> s.pressure), (App)Codec.DOUBLE.fieldOf("distance").forGetter(s -> s.distance), (App)Codec.STRING.xmap(str -> EnumType.valueOf(str.toUpperCase()), Enum::name).fieldOf("type").forGetter(s -> s.type), (App)Codec.BOOL.fieldOf("oxygen").forGetter(s -> s.oxygen), (App)Codec.BOOL.fieldOf("colonies").forGetter(s -> s.colonies), (App)Codec.INT.fieldOf("angle").forGetter(s -> s.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(s -> s.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(s -> s.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(s -> s.rotation)).apply((Applicative)instance, (name, systemStr, textureStr, level, planetStr, temperature, pressure, distance, type, oxygen, colonies, angle, time, size, rotation) -> {
        ISystem system = SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr));
        IPlanet planet = (IPlanet)SpaceNet.instance.getBodyFromName((String)planetStr);
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        SpaceInit.regSatellite.add(() -> new Satellite((String)name, system, texture, (EnumLevels)((Object)((Object)level)), planet, (int)temperature, (boolean)pressure, (double)distance, (EnumType)((Object)((Object)type)), (boolean)oxygen, (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation));
        return new SatelliteRecipe("", Collections.emptyList(), "");
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, SatelliteRecipe> STREAM_CODEC = StreamCodec.of(SatelliteSerializer::toNetwork, SatelliteSerializer::fromNetwork);

    private static SatelliteRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new SatelliteRecipe("", new ArrayList<ItemStack>(), "");
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, SatelliteRecipe p_320586_) {
    }

    public MapCodec<SatelliteRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, SatelliteRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

