/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe.universalrecipe;

import com.denfop.api.space.Asteroid;
import com.denfop.api.space.EnumLevels;
import com.denfop.api.space.EnumType;
import com.denfop.api.space.IStar;
import com.denfop.api.space.ISystem;
import com.denfop.api.space.SpaceInit;
import com.denfop.api.space.SpaceNet;
import com.denfop.recipe.universalrecipe.AsteroidRecipe;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class AsteroidSerializer
implements RecipeSerializer<AsteroidRecipe> {
    public static final MapCodec<AsteroidRecipe> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("name").forGetter(a -> a.name), (App)Codec.STRING.fieldOf("system").forGetter(a -> a.systemName), (App)Codec.STRING.fieldOf("texture").forGetter(a -> a.texturePath), (App)Codec.STRING.xmap(s -> EnumLevels.valueOf(s.toUpperCase()), Enum::name).fieldOf("level").forGetter(a -> a.level), (App)Codec.STRING.fieldOf("star").forGetter(a -> a.starName), (App)Codec.INT.fieldOf("temperature").forGetter(a -> a.temperature), (App)Codec.DOUBLE.fieldOf("distance").forGetter(a -> a.distance), (App)Codec.STRING.xmap(s -> EnumType.valueOf(s.toUpperCase()), Enum::name).fieldOf("type").forGetter(a -> a.type), (App)Codec.BOOL.fieldOf("colonies").forGetter(a -> a.colonies), (App)Codec.INT.fieldOf("angle").forGetter(a -> a.angle), (App)Codec.DOUBLE.fieldOf("time").forGetter(a -> a.time), (App)Codec.DOUBLE.fieldOf("size").forGetter(a -> a.size), (App)Codec.DOUBLE.fieldOf("rotation").forGetter(a -> a.rotation), (App)Codec.DOUBLE.fieldOf("minLocation").forGetter(a -> a.minLocation), (App)Codec.DOUBLE.fieldOf("maxLocation").forGetter(a -> a.maxLocation), (App)Codec.INT.fieldOf("amount").forGetter(a -> a.amount)).apply((Applicative)instance, (name, systemStr, textureStr, level, starStr, temperature, distance, type, colonies, angle, time, size, rotation, minLocation, maxLocation, amount) -> {
        ISystem system = SpaceNet.instance.getSystem().stream().filter(s -> s.getName().equals(systemStr.toLowerCase())).findFirst().orElseThrow(() -> new IllegalArgumentException("System not found: " + systemStr));
        IStar star = (IStar)SpaceNet.instance.getBodyFromName((String)starStr);
        if (star == null) {
            throw new IllegalArgumentException("Star not found: " + starStr);
        }
        ResourceLocation texture = ResourceLocation.parse((String)(textureStr + ".png"));
        SpaceInit.regAsteroid.add(() -> new Asteroid((String)name, system, texture, (EnumLevels)((Object)((Object)level)), star, (int)temperature, (double)distance, (EnumType)((Object)((Object)type)), (boolean)colonies, (int)angle, (double)time, (double)size, (double)rotation, (double)minLocation, (double)maxLocation, (int)amount));
        return new AsteroidRecipe("", Collections.emptyList(), "");
    }));
    public static final StreamCodec<RegistryFriendlyByteBuf, AsteroidRecipe> STREAM_CODEC = StreamCodec.of(AsteroidSerializer::toNetwork, AsteroidSerializer::fromNetwork);

    private static AsteroidRecipe fromNetwork(RegistryFriendlyByteBuf p_319998_) {
        return new AsteroidRecipe("", new ArrayList<ItemStack>(), "");
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, AsteroidRecipe p_320586_) {
    }

    public MapCodec<AsteroidRecipe> codec() {
        return MAP_CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, AsteroidRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

