/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.recipe;

import com.denfop.api.Recipes;
import com.denfop.api.crafting.BaseShapelessRecipe;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.recipe.IInputItemStack;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class IndustrialShapelessRecipeSerializer
implements RecipeSerializer<BaseShapelessRecipe> {
    public static final StreamCodec<RegistryFriendlyByteBuf, BaseShapelessRecipe> STREAM_CODEC = StreamCodec.of(IndustrialShapelessRecipeSerializer::toNetwork, IndustrialShapelessRecipeSerializer::fromNetwork);
    private static final MapCodec<BaseShapelessRecipe> CODEC = RecordCodecBuilder.mapCodec(p_340779_ -> p_340779_.group((App)Codec.STRING.optionalFieldOf("group", (Object)"").forGetter(Recipe::getGroup), (App)CraftingBookCategory.CODEC.fieldOf("category").orElse((Object)CraftingBookCategory.MISC).forGetter(BaseShapelessRecipe::category), (App)ItemStack.STRICT_CODEC.fieldOf("result").forGetter(BaseShapelessRecipe::getOutput), (App)Ingredient.CODEC_NONEMPTY.listOf().fieldOf("ingredients").flatXmap(p_301021_ -> {
        Object[] aingredient = (Ingredient[])p_301021_.toArray(Ingredient[]::new);
        if (aingredient.length == 0) {
            return DataResult.error(() -> "No ingredients for shapeless recipe");
        }
        return aingredient.length > 9 ? DataResult.error(() -> "Too many ingredients for shapeless recipe. The maximum is: %s".formatted(9)) : DataResult.success((Object)NonNullList.of((Object)Ingredient.EMPTY, (Object[])aingredient));
    }, DataResult::success).forGetter(BaseShapelessRecipe::getIngredients)).apply((Applicative)p_340779_, (group, category, result, ingredient) -> {
        ArrayList<IInputItemStack> partRecipes = new ArrayList<IInputItemStack>();
        Iterator iterator = ingredient.iterator();
        while (iterator.hasNext()) {
            Ingredient entry;
            Ingredient ingredient1 = entry = (Ingredient)iterator.next();
            IInputItemStack input = Recipes.inputFactory.getInput(ingredient1);
            partRecipes.add(input);
        }
        return new BaseShapelessRecipe((ItemStack)result, (List<IInputItemStack>)partRecipes);
    }));

    private static BaseShapelessRecipe fromNetwork(RegistryFriendlyByteBuf pBuffer) {
        return BaseShapelessRecipe.create(new CustomPacketBuffer(pBuffer));
    }

    private static void toNetwork(RegistryFriendlyByteBuf p_320738_, BaseShapelessRecipe p_320586_) {
        p_320586_.toNetwork(p_320738_);
    }

    public MapCodec<BaseShapelessRecipe> codec() {
        return CODEC;
    }

    public StreamCodec<RegistryFriendlyByteBuf, BaseShapelessRecipe> streamCodec() {
        return STREAM_CODEC;
    }
}

