/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.pressure;

import com.denfop.api.pressure.IPressureNet;
import com.denfop.api.pressure.IPressureTile;
import com.denfop.pressure.EventHandler;
import com.denfop.pressure.PressureNetLocal;
import java.util.Map;
import java.util.WeakHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class PressureNetGlobal
implements IPressureNet {
    private static Map<ResourceKey<Level>, PressureNetLocal> worldToEnergyNetMap = new WeakHashMap<ResourceKey<Level>, PressureNetLocal>();

    public static PressureNetGlobal initialize() {
        new EventHandler();
        return new PressureNetGlobal();
    }

    public static void onWorldUnload(Level world) {
        PressureNetLocal local = worldToEnergyNetMap.remove(world.dimension());
        if (local != null) {
            local.onUnload();
        }
    }

    public static PressureNetLocal getForWorld(Level world) {
        if (world == null) {
            return null;
        }
        if (!worldToEnergyNetMap.containsKey(world.dimension())) {
            worldToEnergyNetMap.put((ResourceKey<Level>)world.dimension(), new PressureNetLocal());
        }
        return worldToEnergyNetMap.get(world.dimension());
    }

    public static void onTickEnd(Level world) {
        PressureNetLocal energyNet = PressureNetGlobal.getForWorld(world);
        if (energyNet != null) {
            energyNet.onTickEnd();
        }
    }

    @Override
    public IPressureTile getSubTile(Level var1, BlockPos var2) {
        PressureNetLocal local = PressureNetGlobal.getForWorld(var1);
        if (local != null) {
            return local.getSubTile(var1, var2);
        }
        return null;
    }
}

