/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.network.packet;

import com.denfop.IUCore;
import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.EnumTypePacket;
import com.denfop.network.packet.IPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class PacketUpdateInformationAboutQuestsPlayer
implements IPacket {
    private CustomPacketBuffer buffer;

    public PacketUpdateInformationAboutQuestsPlayer() {
    }

    public PacketUpdateInformationAboutQuestsPlayer(Map<String, List<String>> map, Player player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(player.registryAccess());
        buffer.writeByte(this.getId());
        buffer.writeUUID(player.getUUID());
        buffer.writeVarInt(map.size());
        for (Map.Entry<String, List<String>> entry : map.entrySet()) {
            buffer.writeString(entry.getKey());
            List<String> list = entry.getValue();
            buffer.writeVarInt(list.size());
            for (String str : list) {
                buffer.writeString(str);
            }
        }
        this.buffer = buffer;
        IUCore.network.getServer().sendPacket((IPacket)this, buffer, (ServerPlayer)player);
    }

    @Override
    public CustomPacketBuffer getPacketBuffer() {
        return this.buffer;
    }

    @Override
    public void setPacketBuffer(CustomPacketBuffer customPacketBuffer) {
        this.buffer = customPacketBuffer;
    }

    @Override
    public byte getId() {
        return 70;
    }

    @Override
    public void readPacket(CustomPacketBuffer customPacketBuffer, Player entityPlayer) {
        UUID uuid = customPacketBuffer.readUUID();
        int mapSize = customPacketBuffer.readVarInt();
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        for (int i = 0; i < mapSize; ++i) {
            String key = customPacketBuffer.readString();
            int listSize = customPacketBuffer.readVarInt();
            ArrayList<String> list = new ArrayList<String>();
            for (int j = 0; j < listSize; ++j) {
                list.add(customPacketBuffer.readString());
            }
            map.put(key, list);
        }
        GuideBookCore.instance.setData(uuid, map);
    }

    @Override
    public EnumTypePacket getPacketType() {
        return EnumTypePacket.SERVER;
    }
}

