/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.upgradekit;

import com.denfop.IUCore;
import com.denfop.IUItem;
import com.denfop.blocks.ISubEnum;
import com.denfop.items.ItemMain;
import com.denfop.tiles.base.TileElectricBlock;
import com.denfop.tiles.wiring.EnumElectricBlock;
import com.denfop.utils.ModUtils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ItemUpgradeKit<T extends Enum<T>>
extends ItemMain<T> {
    public ItemUpgradeKit(T element) {
        super(new Item.Properties(), element);
    }

    @Override
    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"waring_kit"));
        super.appendHoverText(stack, world, tooltip, flag);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.UpgradeTab;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        TileElectricBlock tile;
        EnumElectricBlock enumblock;
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        InteractionHand hand = context.getHand();
        if (world.isClientSide || player == null) {
            return InteractionResult.PASS;
        }
        int meta = ((ISubEnum)this.getElement()).getId();
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity instanceof TileElectricBlock && (enumblock = (tile = (TileElectricBlock)blockEntity).getElectricBlock()) != null && enumblock.kit_meta == meta) {
            ItemStack stack1 = new ItemStack(tile.getElectricBlock().chargepad ? IUItem.chargepadelectricblock.getItem(tile.getElectricBlock().meta) : IUItem.electricblock.getItem(tile.getElectricBlock().meta), 1);
            CompoundTag nbt = ModUtils.nbt(stack1);
            nbt.putDouble("energy", tile.energy.getEnergy());
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            block.playerWillDestroy(world, pos, state, player);
            world.removeBlock(pos, false);
            block.destroy((LevelAccessor)world, pos, state);
            List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(Vec3.atCenterOf((Vec3i)pos.offset(-1, -1, -1)), Vec3.atCenterOf((Vec3i)pos.offset(1, 1, 1))));
            for (ItemEntity item : items) {
                item.discard();
            }
            ItemEntity itemEntity = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), stack1);
            itemEntity.setPickUpDelay(0);
            world.addFreshEntity((Entity)itemEntity);
            List<ItemStack> dropList = tile.getDrop();
            for (ItemStack drop : dropList) {
                ItemEntity dropEntity = new ItemEntity(world, player.getX(), player.getY(), player.getZ(), drop);
                dropEntity.setPickUpDelay(0);
                world.addFreshEntity((Entity)dropEntity);
            }
            stack.shrink(1);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public static enum Types implements ISubEnum
    {
        upgradekit(0),
        upgradekit1(1),
        upgradekit2(2),
        upgradekit3(3),
        upgradekit4(4),
        upgradekit5(5),
        upgradekit6(6),
        upgradekit7(7),
        upgradekit8(8);

        private final String name = this.name().toLowerCase(Locale.US);
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "upgradekitstorage";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

