/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.space;

import com.denfop.ElectricItem;
import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.space.BaseSpaceSystem;
import com.denfop.api.space.rovers.api.IRoversItem;
import com.denfop.api.space.rovers.enums.EnumRoversLevel;
import com.denfop.api.space.rovers.enums.EnumRoversLevelFluid;
import com.denfop.api.space.rovers.enums.EnumTypeRovers;
import com.denfop.api.space.rovers.enums.EnumTypeUpgrade;
import com.denfop.api.space.upgrades.BaseSpaceUpgradeSystem;
import com.denfop.api.space.upgrades.SpaceUpgradeSystem;
import com.denfop.api.space.upgrades.event.EventItemLoad;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.FluidHandlerFix;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.Util;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class ItemRover
extends ItemFluidContainer
implements IRoversItem,
IEnergyItem,
IItemTab {
    private final EnumRoversLevel enumRoversLevel;
    private final EnumTypeRovers typeRovers;
    private final String name;
    private final double maxEnergy;
    private final double transferEnergy;
    private final int tier;
    private final EnumRoversLevelFluid fluids;
    private final double progress;
    public List<EnumTypeUpgrade> upgrades = Arrays.asList(EnumTypeUpgrade.values());

    public ItemRover(String name, int capacity, EnumRoversLevel enumRoversLevel, EnumTypeRovers typeRovers, int tier, double maxEnergy, double transferEnergy, EnumRoversLevelFluid fluids, double progress) {
        super(new Item.Properties().setNoRepair().stacksTo(1), capacity);
        this.name = name;
        this.maxEnergy = maxEnergy;
        this.fluids = fluids;
        this.transferEnergy = transferEnergy;
        this.tier = tier;
        this.progress = progress;
        this.enumRoversLevel = enumRoversLevel;
        this.typeRovers = typeRovers;
        BaseSpaceUpgradeSystem.list.add(() -> SpaceUpgradeSystem.system.addRecipe(this, EnumTypeUpgrade.values()));
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.SpaceTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab tab, NonNullList<ItemStack> subItems) {
        if (this.allowedIn(tab)) {
            subItems.add((Object)new ItemStack((ItemLike)this, 1));
            ItemStack stack1 = new ItemStack((ItemLike)this);
            ElectricItem.manager.charge(stack1, Double.MAX_VALUE, Integer.MAX_VALUE, true, false);
            subItems.add((Object)stack1);
            for (Map.Entry<Fluid, Integer> entry : BaseSpaceSystem.fluidToLevel.entrySet()) {
                if (entry.getValue() > this.enumRoversLevel.ordinal() + 1) continue;
                ItemStack stack = new ItemStack((ItemLike)this);
                ElectricItem.manager.charge(stack, Double.MAX_VALUE, Integer.MAX_VALUE, true, false);
                subItems.add((Object)this.getItemStack(stack, entry.getKey()));
            }
        }
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.rover.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Override
    public boolean canProvideEnergy(ItemStack var1) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack var1) {
        return this.maxEnergy;
    }

    @Override
    public short getTierItem(ItemStack var1) {
        return (short)this.tier;
    }

    @Override
    public boolean canfill(Fluid var1) {
        Integer level = BaseSpaceSystem.fluidToLevel.get(var1);
        return level != null && level <= this.enumRoversLevel.ordinal() + 1;
    }

    @Override
    public double getTransferEnergy(ItemStack var1) {
        return this.transferEnergy;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public EnumTypeRovers getType() {
        return this.typeRovers;
    }

    @Override
    public IFluidHandlerItem getFluidHandler(ItemStack stack) {
        return FluidHandlerFix.getFluidHandler(stack);
    }

    public void inventoryTick(ItemStack itemStack, Level world, Entity entity, int slot, boolean selected) {
        if (!SpaceUpgradeSystem.system.hasInMap(itemStack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, itemStack));
        }
    }

    @Override
    public EnumRoversLevel getLevel() {
        return this.enumRoversLevel;
    }

    @Override
    public double getAddProgress() {
        return this.progress;
    }

    @Override
    public List<EnumTypeUpgrade> getUpgradeModules() {
        return this.upgrades;
    }
}

