/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.relocator;

import com.denfop.network.packet.CustomPacketBuffer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;

public class Point {
    private final String name;
    private final BlockPos pos;

    public Point(String name, BlockPos pos) {
        this.name = name;
        this.pos = pos;
    }

    public Point(CustomPacketBuffer buffer) {
        this.name = buffer.readString();
        this.pos = buffer.readBlockPos();
    }

    public Point(CompoundTag compound) {
        this.name = compound.getString("Name");
        this.pos = BlockPos.of((long)compound.getLong("Pos"));
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getName() {
        return this.name;
    }

    public void writeToBuffer(CustomPacketBuffer buffer) {
        buffer.writeString(this.name);
        buffer.writeBlockPos(this.pos);
    }

    public CompoundTag writeToNBT(CompoundTag compound) {
        compound.putString("Name", this.name);
        compound.putLong("Pos", this.pos.asLong());
        return compound;
    }
}

