/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.reactors;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.items.reactors.ItemDamage;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import org.jetbrains.annotations.Nullable;

public class ItemsPumps
extends ItemDamage
implements IItemTab {
    private final int power;
    private final int energy;
    private final int level;

    public ItemsPumps(int maxDamage, int level, int power, int energy) {
        super(new Item.Properties().stacksTo(1), maxDamage);
        this.power = power;
        this.level = level;
        this.energy = energy;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ReactorsTab;
    }

    @Override
    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "iu." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    public void appendHoverText(ItemStack p_41421_, @Nullable Item.TooltipContext p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)(Localization.translate("iu.reactoritem.durability") + " " + (this.getMaxCustomDamage(p_41421_) - this.getCustomDamage(p_41421_)) + "/" + this.getMaxCustomDamage(p_41421_))));
        p_41423_.add((Component)Component.literal((String)(Localization.translate("reactor.component_level") + (this.level + 1))));
        p_41423_.add((Component)Component.literal((String)Localization.translate("reactor.component_level1")));
    }

    public int getLevel() {
        return this.level;
    }

    public int getEnergy() {
        return this.energy;
    }

    public int getPower() {
        return this.power;
    }
}

