/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.Localization;
import com.denfop.items.energy.ItemToolIU;
import com.denfop.items.energy.instruments.EnumTypeInstruments;
import com.denfop.utils.ExperienceUtils;
import com.denfop.utils.ModUtils;
import com.denfop.utils.RetraceDiggingUtils;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.ItemAbilities;
import net.neoforged.neoforge.common.ItemAbility;

public class ItemIronHammer
extends ItemToolIU {
    private final Set<BlockState> mineableBlocks = EnumTypeInstruments.DRILL.getMineableBlocks();
    private final List<TagKey<Block>> item_tools = EnumTypeInstruments.DRILL.getListItems();

    public ItemIronHammer() {
        super((TagKey<Block>)BlockTags.MINEABLE_WITH_PICKAXE);
    }

    @Override
    public boolean isEnchantable(ItemStack p_41456_) {
        return true;
    }

    public int getEnchantmentValue(ItemStack stack) {
        return Tiers.IRON.getEnchantmentValue();
    }

    @Override
    public int getEnchantmentValue() {
        return Tiers.IRON.getEnchantmentValue();
    }

    @Override
    public String[] getTags() {
        return new String[]{ItemTags.PICKAXES.location().toString()};
    }

    public void appendHoverText(ItemStack p_41421_, Item.TooltipContext p_339594_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.appendHoverText(p_41421_, p_339594_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.literal((String)Localization.translate("iu.hammer.info")));
    }

    public boolean mineBlock(ItemStack stack, Level p_41417_, BlockState state, BlockPos pos, LivingEntity p_41420_) {
        if (!(p_41420_ instanceof Player)) {
            return false;
        }
        Player player = (Player)p_41420_;
        Level world = player.level();
        Block block = state.getBlock();
        BlockHitResult mop = RetraceDiggingUtils.retrace(player);
        if (state.isAir()) {
            return super.mineBlock(stack, p_41417_, state, pos, (LivingEntity)player);
        }
        byte aoe = 0;
        if (player.isShiftKeyDown() && mop.getType() != HitResult.Type.MISS) {
            return this.breakBlock(world, block, mop, aoe, player, pos, stack);
        }
        return this.breakBlock(world, block, mop, (byte)(1 + aoe), player, pos, stack);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        if (this.mineableBlocks.contains(state)) {
            return true;
        }
        for (TagKey<Block> blockTagKey : this.item_tools) {
            if (!state.is(blockTagKey)) continue;
            return true;
        }
        return false;
    }

    private int getExperience(BlockState state, Level world, BlockPos pos_block, Entity entity, ItemStack stack, Block localBlock) {
        int col = localBlock.getExpDrop(state, (LevelAccessor)world, pos_block, null, entity, stack);
        return col;
    }

    public boolean breakBlock(Level level, Block block, BlockHitResult mop, byte modeItem, Player player, BlockPos pos, ItemStack stack) {
        byte xRange = modeItem;
        byte yRange = modeItem;
        byte zRange = modeItem;
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        byte digDepth = 0;
        switch (mop.getDirection()) {
            case DOWN: 
            case UP: {
                yRange = digDepth;
                break;
            }
            case NORTH: 
            case SOUTH: {
                zRange = digDepth;
                break;
            }
            case WEST: 
            case EAST: {
                xRange = digDepth;
            }
        }
        boolean silkTouch = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)stack) > 0;
        int fortune = EnchantmentHelper.getItemEnchantmentLevel((Holder)player.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (ItemStack)stack);
        fortune = Math.min(3, fortune);
        int yOffset = yRange > 0 ? yRange - 1 : 0;
        stack.hurtAndBreak(1, (LivingEntity)player, EquipmentSlot.MAINHAND);
        if (!player.getAbilities().instabuild) {
            for (int xPos = x - xRange; xPos <= x + xRange; ++xPos) {
                for (int yPos = y - yRange + yOffset; yPos <= y + yRange + yOffset; ++yPos) {
                    for (int zPos = z - zRange; zPos <= z + zRange && stack.getDamageValue() > 0; ++zPos) {
                        BlockPos blockPos = new BlockPos(xPos, yPos, zPos);
                        BlockState state = level.getBlockState(blockPos);
                        Block localBlock = state.getBlock();
                        if (localBlock == Blocks.AIR || !this.isCorrectToolForDrops(stack, state) || !(state.getDestroySpeed((BlockGetter)level, blockPos) >= 0.0f)) continue;
                        if (state.getDestroySpeed((BlockGetter)level, blockPos) > 0.0f) {
                            this.onDestroyed(stack, level, state, blockPos, (LivingEntity)player);
                        }
                        if (silkTouch) continue;
                        ExperienceUtils.addPlayerXP(player, this.getExperience(state, level, blockPos, (Entity)player, stack, localBlock));
                    }
                }
            }
        } else if (stack.getDamageValue() > 0) {
            BlockState state = level.getBlockState(pos);
            Block localBlock = state.getBlock();
            if (localBlock != Blocks.AIR && this.isCorrectToolForDrops(stack, state) && state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f || block == Blocks.INFESTED_STONE) {
                if (state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f) {
                    this.onDestroyed(stack, level, state, pos, (LivingEntity)player);
                }
                if (!silkTouch) {
                    ExperienceUtils.addPlayerXP(player, this.getExperience(state, level, pos, (Entity)player, stack, localBlock));
                }
            } else if (state.getDestroySpeed((BlockGetter)level, pos) >= 0.0f) {
                return this.onDestroyed(stack, level, state, pos, (LivingEntity)player);
            }
        }
        return true;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        return this.mineableBlocks.contains(state) ? this.getTier().getSpeed() : 1.0f;
    }

    public boolean canPerformAction(ItemStack stack, ItemAbility toolAction) {
        return ItemAbilities.DEFAULT_SHOVEL_ACTIONS.contains(toolAction) || ItemAbilities.DEFAULT_PICKAXE_ACTIONS.contains(toolAction);
    }

    public boolean onDestroyed(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        Player player = (Player)entity;
        Block block = state.getBlock();
        if (state.isAir()) {
            return false;
        }
        if (block instanceof LiquidBlock || state.getDestroySpeed((BlockGetter)world, pos) == -1.0f && !player.isCreative()) {
            return false;
        }
        if (!world.isClientSide) {
            ServerLevel serverWorld = (ServerLevel)world;
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (CommonHooks.fireBlockBreak((Level)serverWorld, (GameType)serverPlayer.gameMode.getGameModeForPlayer(), (ServerPlayer)serverPlayer, (BlockPos)pos, (BlockState)state).isCanceled()) {
                return false;
            }
            if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.getFluidState(pos))) {
                block.destroy((LevelAccessor)world, pos, state);
                block.playerDestroy(world, (Player)((ServerPlayer)entity), pos, state, null, stack);
                List items = world.getEntitiesOfClass(ItemEntity.class, new AABB(Vec3.atLowerCornerOf((Vec3i)pos.offset(-1, -1, -1)), Vec3.atLowerCornerOf((Vec3i)pos.offset(1, 1, 1))));
                serverPlayer.causeFoodExhaustion(-0.025f);
                if (ModUtils.getOre(block)) {
                    for (ItemEntity item : items) {
                        if (world.isClientSide) continue;
                        item.setPos(player.getX(), player.getY(), player.getZ());
                        item.setPickUpDelay(0);
                    }
                }
            }
        } else if (block.onDestroyedByPlayer(state, world, pos, (Player)((ServerPlayer)entity), true, world.getFluidState(pos))) {
            block.destroy((LevelAccessor)world, pos, state);
            block.playerDestroy(world, (Player)((ServerPlayer)entity), pos, state, null, stack);
        }
        return true;
    }
}

