/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.energy;

import com.denfop.ElectricItem;
import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.item.IEnergyItem;
import com.denfop.api.upgrade.EnumUpgrades;
import com.denfop.api.upgrade.IUpgradeItem;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.api.upgrade.event.EventItemLoad;
import com.denfop.audio.EnumSound;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.EnumInfoUpgradeModules;
import com.denfop.items.IProperties;
import com.denfop.items.energy.EntityAdvArrow;
import com.denfop.network.packet.PacketSoundPlayer;
import com.denfop.utils.ElectricItemManager;
import com.denfop.utils.KeyboardClient;
import com.denfop.utils.ModUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.player.ArrowLooseEvent;
import net.neoforged.neoforge.event.entity.player.ArrowNockEvent;

public class ItemEnergyBow
extends BowItem
implements IEnergyItem,
IUpgradeItem,
IProperties,
IItemTab {
    static final int[] CHARGE = new int[]{1500, 750, 2000, 5000, 1000};
    static final String[] MODE = new String[]{"normal", "rapidfire", "spread", "sniper", "flame"};
    private final float type;
    private final String name;
    private final double nanoBowBoost;
    private final int tier;
    private final int transferenergy;
    private final int maxenergy;
    private String nameItem;

    public ItemEnergyBow(String name, double nanoBowBoost, int tier, int transferenergy, int maxenergy, float type) {
        super(new Item.Properties().stacksTo(1).component(DataComponentsInit.ENERGY, (Object)0.0).component(DataComponentsInit.MODE, (Object)0));
        this.name = name;
        this.nanoBowBoost = nanoBowBoost;
        this.tier = tier;
        this.transferenergy = transferenergy;
        this.maxenergy = maxenergy;
        this.type = type;
        if (this.properties().length > 0) {
            IUCore.proxy.addProperties(this);
        }
        IUCore.runnableListAfterRegisterItem.add(() -> UpgradeSystem.system.addRecipe((Item)this, EnumUpgrades.BOW.list));
    }

    public static float getArrowVelocity(int charge) {
        float f = (float)charge / 20.0f;
        f = (f * f + f * 2.0f) / 3.0f;
        return Math.min(f, 1.5f);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        if (!UpgradeSystem.system.hasInMap(stack)) {
            NeoForge.EVENT_BUS.post((Event)new EventItemLoad(world, this, stack));
        }
    }

    public void onUseTick(Level pLevel, LivingEntity livingEntity, ItemStack stack, int i) {
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
        if (mode == 1) {
            int bowEnergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            int j = this.getUseDuration(stack, livingEntity) - i;
            if (j >= 10 && ElectricItem.manager.canUse(stack, (double)CHARGE[1] - (double)CHARGE[1] * 0.1 * (double)bowEnergy)) {
                this.releaseUsing(stack, livingEntity.level(), livingEntity, i);
                player.stopUsingItem();
            }
        }
    }

    @Override
    public String[] properties() {
        return new String[]{"pulling", "pull", "mode"};
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, Player player, @Nonnull InteractionHand hand) {
        int bowenergy;
        ItemStack stack = player.getItemInHand(hand);
        int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
        int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
        if (IUCore.keyboard.isChangeKeyDown(player)) {
            if (++mode >= CHARGE.length) {
                mode = 0;
            }
            stack.set(DataComponentsInit.MODE, (Object)mode);
            if (!world.isClientSide) {
                IUCore.proxy.messagePlayer(player, Localization.translate("info.nanobow." + MODE[mode]));
            }
        } else if (player.getAbilities().instabuild || ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
            player.startUsingItem(hand);
        }
        ArrowNockEvent event = new ArrowNockEvent(player, stack, hand, world, false);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.getAction();
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public UseAnim getUseAnimation(ItemStack p_40678_) {
        return UseAnim.BOW;
    }

    public void releaseUsing(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull LivingEntity entityLiving, int timeLeft) {
        float f;
        if (!(entityLiving instanceof Player)) {
            super.releaseUsing(stack, world, entityLiving, timeLeft);
            return;
        }
        Player player = (Player)entityLiving;
        int mode = (Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0);
        int charge = this.getMaxItemUseDuration(stack) - timeLeft;
        ArrowLooseEvent event = new ArrowLooseEvent(player, stack, world, charge, false);
        NeoForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        charge = event.getCharge();
        if (mode == 3) {
            charge /= 2;
        }
        if (mode == 1) {
            charge *= 4;
        }
        if ((double)(f = ItemEnergyBow.getArrowVelocity(charge)) < 0.1) {
            return;
        }
        if (!world.isClientSide) {
            int bowenergy;
            EntityAdvArrow arrow = this.createArrow(world, stack, (LivingEntity)player);
            arrow = this.customArrow((AbstractArrow)arrow);
            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 1.0f);
            if (f == 1.5f) {
                arrow.setCritArrow(true);
            }
            int bowdamage = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWDAMAGE, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWDAMAGE, (ItemStack)stack).number : 0;
            arrow.setBaseDamage(arrow.getBaseDamage() + (double)this.type * 2.5 + 0.5 + (double)this.type * 2.5 * 0.25 * (double)bowdamage);
            int j = EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.POWER), (ItemStack)stack);
            if (j > 0) {
                arrow.setBaseDamage(arrow.getBaseDamage() + (double)j * 0.5 + 0.5);
            }
            if (mode == 0 && arrow.isCritArrow()) {
                j += 3;
            } else if (mode == 1 && arrow.isCritArrow()) {
                ++j;
            } else if (mode == 3 && arrow.isCritArrow()) {
                j += 8;
            }
            if (j > 0) {
                arrow.setBaseDamage(arrow.getBaseDamage() + (double)j * 0.5 + 0.5);
            }
            if (this.nanoBowBoost > 0.0) {
                arrow.setBaseDamage(arrow.getBaseDamage() + this.nanoBowBoost * 0.5 + 0.5);
            }
            int k = EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.PUNCH), (ItemStack)stack);
            if (mode == 0 && arrow.isCritArrow()) {
                ++k;
            } else if (mode == 3 && arrow.isCritArrow()) {
                k += 5;
            }
            if (k > 0) {
                arrow.setKsnockback(k);
            }
            if (EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FLAME), (ItemStack)stack) > 0) {
                arrow.igniteForSeconds(100.0f);
            }
            if (mode == 4 && arrow.isCritArrow()) {
                arrow.igniteForSeconds(2000.0f);
            }
            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            int n = bowenergy = UpgradeSystem.system.hasModules(EnumInfoUpgradeModules.BOWENERGY, stack) ? UpgradeSystem.system.getModules((EnumInfoUpgradeModules)EnumInfoUpgradeModules.BOWENERGY, (ItemStack)stack).number : 0;
            if (mode == 2) {
                if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                    ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (LivingEntity)player);
                    new PacketSoundPlayer(EnumSound.bow, player);
                    world.addFreshEntity((Entity)arrow);
                    if (arrow.isCritArrow()) {
                        this.spawnAdditionalArrows(world, player, f, arrow);
                    }
                }
            } else if (ElectricItem.manager.canUse(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy)) {
                ElectricItem.manager.use(stack, (double)CHARGE[mode] - (double)CHARGE[mode] * 0.1 * (double)bowenergy, (LivingEntity)player);
                new PacketSoundPlayer(EnumSound.bow, player);
                world.addFreshEntity((Entity)arrow);
            }
        }
    }

    private void spawnAdditionalArrows(Level world, Player player, float f, Arrow originalArrow) {
        for (int i = 0; i < 4; ++i) {
            EntityAdvArrow arrow = this.createArrow(world, player.getItemInHand(InteractionHand.MAIN_HAND), (LivingEntity)player);
            arrow = this.customArrow((AbstractArrow)arrow);
            arrow.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, f * 3.0f, 1.0f);
            arrow.setBaseDamage(f * 2.0f);
            arrow.setPosRaw(originalArrow.getX() + (double)(i - 2) * 0.25, originalArrow.getY(), originalArrow.getZ());
            arrow.setCritArrow(true);
            arrow.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
            world.addFreshEntity((Entity)arrow);
        }
    }

    public int getMaxItemUseDuration(@Nonnull ItemStack stack) {
        switch ((Integer)stack.getOrDefault(DataComponentsInit.MODE, (Object)0)) {
            case 3: 
            case 5: {
                return 144000;
            }
            case 1: {
                return 18000;
            }
        }
        return 72000;
    }

    public EntityAdvArrow customArrow(AbstractArrow arrow) {
        return (EntityAdvArrow)arrow;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack stack, ClientLevel world, LivingEntity entityIn, int p174679, String property) {
        if (property.equals("pulling")) {
            return entityIn != null && entityIn.isUsingItem() && entityIn.getUseItem() == stack ? 1.0f : 0.0f;
        }
        if (property.equals("mode")) {
            if (((String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"")).isEmpty()) {
                return -1.0f;
            }
            String[] mode = new String[]{"Zelen", "Demon", "Dark", "Cold", "Ender", "Ukraine", "Fire", "Snow", "Taiga", "Desert", "Emerald"};
            for (int i = 0; i < mode.length; ++i) {
                if (!((String)stack.getOrDefault(DataComponentsInit.SKIN, (Object)"")).equals(mode[i])) continue;
                return i;
            }
        }
        if (entityIn == null) {
            return 0.0f;
        }
        return !(entityIn.getUseItem().getItem() instanceof BowItem) ? 0.0f : (float)(stack.getUseDuration(entityIn) - entityIn.getUseItemRemainingTicks()) / 20.0f;
    }

    public EntityAdvArrow createArrow(Level worldIn, ItemStack stack, LivingEntity shooter) {
        EntityAdvArrow entitytippedarrow = new EntityAdvArrow(worldIn, shooter, new ItemStack((ItemLike)Items.ARROW), stack);
        entitytippedarrow.setStack(stack);
        return entitytippedarrow;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(@Nonnull ItemStack stack, Item.TooltipContext world, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flag) {
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append(KeyboardClient.changemode.getKey().getDisplayName()).append((Component)Component.translatable((String)"iu.changemode_rcm")));
        }
        switch (this.tier) {
            case 2: {
                tooltip.add((Component)Component.translatable((String)"iu.bow.maxdamage").append(String.valueOf(47)));
                break;
            }
            case 3: {
                tooltip.add((Component)Component.translatable((String)"iu.bow.maxdamage").append(String.valueOf(56)));
                break;
            }
            case 4: {
                tooltip.add((Component)Component.translatable((String)"iu.bow.maxdamage").append(String.valueOf(71)));
            }
        }
        ModUtils.mode(stack, tooltip);
        super.appendHoverText(stack, world, tooltip, flag);
    }

    @Override
    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    @Override
    public int getBarColor(ItemStack stack) {
        return ModUtils.convertRGBcolorToInt(33, 91, 199);
    }

    @Override
    public int getBarWidth(ItemStack stack) {
        return 13 - (int)(13.0 * Math.min(Math.max(1.0 - ElectricItem.manager.getCharge(stack) / ElectricItem.manager.getMaxCharge(stack), 0.0), 1.0));
    }

    @Override
    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    @Override
    public double getMaxEnergy(ItemStack stack) {
        return this.maxenergy;
    }

    @Override
    public short getTierItem(ItemStack stack) {
        return (short)this.tier;
    }

    @Override
    public double getTransferEnergy(ItemStack stack) {
        return this.transferenergy;
    }

    @Override
    public List<EnumInfoUpgradeModules> getUpgradeModules() {
        return EnumUpgrades.BOW.list;
    }

    public boolean isEnchantable(ItemStack p_41456_) {
        return false;
    }

    public int getEnchantmentValue() {
        return 0;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            ElectricItemManager.addChargeVariants((Item)this, p_41392_);
        }
    }
}

