/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.book;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bee.ItemStackBeeAnalyzer;
import com.denfop.items.book.ItemStackBook;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class ItemBook
extends Item
implements IItemStackInventory,
IItemTab,
IUpdatableItemStackEvent {
    private final String internalName;
    private String nameItem;

    public ItemBook(String internalName) {
        super(new Item.Properties().stacksTo(1));
        this.internalName = internalName;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    @Nonnull
    public String getUnlocalizedName() {
        return "item." + this.internalName + ".name";
    }

    public void save(ItemStack stack, Player player) {
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        containerItem = containerItem.updateOpen(stack, true);
        containerItem.updateSlot(stack, player.getInventory().selected);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackBeeAnalyzer toolbox;
        int slotId;
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        if (containerItem.open() && (slotId = containerItem.slot_inventory()) != itemSlot && !world.isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
            containerItem.updateOpen(stack, false);
        }
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackBeeAnalyzer toolbox;
        if (!player.level().isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerBeeAnalyzer && (toolbox = (ItemStackBeeAnalyzer)((ContainerBeeAnalyzer)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.closeContainer();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        BlockHitResult blockhitresult = ItemBook.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (!player.level().isClientSide && world.getBlockEntity(blockhitresult.getBlockPos()) == null) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackBook(player, stack);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        stack.set(DataComponentsInit.MODE, (Object)event);
    }
}

