/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bee;

import com.denfop.api.bee.IBee;
import com.denfop.api.bee.genetics.EnumGenetic;
import com.denfop.api.bee.genetics.Genome;
import com.denfop.api.pollution.LevelPollution;
import com.denfop.api.radiationsystem.EnumLevelRadiation;
import com.denfop.container.ContainerBase;
import com.denfop.container.ContainerBeeAnalyzer;
import com.denfop.gui.GuiBeeAnalyzer;
import com.denfop.gui.GuiCore;
import com.denfop.items.ItemStackInventory;
import com.denfop.items.bee.ItemJarBees;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemStackBeeAnalyzer
extends ItemStackInventory {
    public final int inventorySize;
    public final ItemStack itemStack1;
    public Genome genome;
    public IBee crop;
    public int weatherGenome = 0;
    public double pestGenome = 1.0;
    public double birthRateGenome = 1.0;
    public double radiusGenome = 1.0;
    public double populationGenome = 1.0;
    public double foodGenome = 1.0;
    public double jellyGenome = 1.0;
    public double productGenome = 1.0;
    public double hardeningGenome = 1.0;
    public double swarmGenome = 1.0;
    public double mortalityGenome = 1.0;
    public boolean sunGenome = false;
    public boolean nightGenome = false;
    public int genomeResistance = 0;
    public int genomeAdaptive = 0;
    public LevelPollution airPollution = LevelPollution.LOW;
    public LevelPollution soilPollution = LevelPollution.LOW;
    public EnumLevelRadiation radiationPollution = EnumLevelRadiation.LOW;

    public ItemStackBeeAnalyzer(Player player, ItemStack stack, int inventorySize) {
        super(player, stack, inventorySize);
        this.inventorySize = inventorySize;
        this.itemStack1 = stack;
    }

    @Override
    public boolean isItemValidForSlot(int i, ItemStack itemstack) {
        return itemstack.getItem() instanceof ItemJarBees;
    }

    public void set() {
        this.reset();
        if (this.genome == null) {
            return;
        }
        if (this.genome.hasGenome(EnumGenetic.WEATHER)) {
            this.weatherGenome = this.genome.getLevelGenome(EnumGenetic.WEATHER, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PEST)) {
            this.pestGenome = this.genome.getLevelGenome(EnumGenetic.PEST, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.BIRTH)) {
            this.birthRateGenome = this.genome.getLevelGenome(EnumGenetic.BIRTH, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIUS)) {
            this.radiusGenome = this.genome.getLevelGenome(EnumGenetic.RADIUS, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.POPULATION)) {
            this.populationGenome = this.genome.getLevelGenome(EnumGenetic.POPULATION, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.FOOD)) {
            this.foodGenome = this.genome.getLevelGenome(EnumGenetic.FOOD, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.JELLY)) {
            this.jellyGenome = this.genome.getLevelGenome(EnumGenetic.JELLY, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.PRODUCT)) {
            this.productGenome = this.genome.getLevelGenome(EnumGenetic.PRODUCT, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.HARDENING)) {
            this.hardeningGenome = this.genome.getLevelGenome(EnumGenetic.HARDENING, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SWARM)) {
            this.swarmGenome = this.genome.getLevelGenome(EnumGenetic.SWARM, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.MORTALITY_RATE)) {
            this.mortalityGenome = this.genome.getLevelGenome(EnumGenetic.MORTALITY_RATE, Double.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SUN)) {
            this.sunGenome = this.genome.getLevelGenome(EnumGenetic.SUN, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.NIGHT)) {
            this.nightGenome = this.genome.getLevelGenome(EnumGenetic.NIGHT, Boolean.class);
        }
        if (this.genome.hasGenome(EnumGenetic.AIR)) {
            this.airPollution = this.genome.getLevelGenome(EnumGenetic.AIR, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.SOIL)) {
            this.soilPollution = this.genome.getLevelGenome(EnumGenetic.SOIL, LevelPollution.class);
        }
        if (this.genome.hasGenome(EnumGenetic.RADIATION)) {
            this.radiationPollution = this.genome.getLevelGenome(EnumGenetic.RADIATION, EnumLevelRadiation.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_RESISTANCE)) {
            this.genomeResistance = this.genome.getLevelGenome(EnumGenetic.GENOME_RESISTANCE, Integer.class);
        }
        if (this.genome.hasGenome(EnumGenetic.GENOME_ADAPTIVE)) {
            this.genomeAdaptive = this.genome.getLevelGenome(EnumGenetic.GENOME_ADAPTIVE, Integer.class);
        }
    }

    public void reset() {
        this.weatherGenome = 0;
        this.pestGenome = 1.0;
        this.swarmGenome = 1.0;
        this.mortalityGenome = 1.0;
        this.birthRateGenome = 1.0;
        this.radiusGenome = 1.0;
        this.populationGenome = 1.0;
        this.foodGenome = 1.0;
        this.jellyGenome = 1.0;
        this.productGenome = 1.0;
        this.hardeningGenome = 1.0;
        this.sunGenome = false;
        this.nightGenome = false;
        this.genomeResistance = 0;
        this.genomeAdaptive = 0;
        this.airPollution = LevelPollution.LOW;
        this.soilPollution = LevelPollution.LOW;
        this.radiationPollution = EnumLevelRadiation.LOW;
    }

    public ContainerBeeAnalyzer getGuiContainer(Player player) {
        return new ContainerBeeAnalyzer(player, this);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiCore<ContainerBase<?>> getGui(Player player, ContainerBase<?> isAdmin) {
        return new GuiBeeAnalyzer((ContainerBeeAnalyzer)isAdmin, this.itemStack1);
    }

    @Override
    public ItemStackInventory getParent() {
        return this;
    }
}

