/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items.bags;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.IUPotion;
import com.denfop.Localization;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.container.ContainerLeadBox;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.bags.ItemStackLeadBox;
import com.denfop.items.reactors.IRadioactiveItemType;
import com.denfop.items.reactors.ItemBaseRod;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemLeadBox
extends Item
implements IItemStackInventory,
IItemTab {
    private final int slots;
    private String nameItem;

    public ItemLeadBox() {
        super(new Item.Properties().stacksTo(1));
        this.slots = 27;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.add((Object)new ItemStack((ItemLike)this, 1));
        }
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.EnergyTab;
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = "item." + pathBuilder.toString().split("\\.")[2];
        }
        return this.nameItem;
    }

    @Override
    public IAdvInventory getInventory(Player player, ItemStack stack) {
        return new ItemStackLeadBox(player, stack, this.slots);
    }

    public void save(ItemStack stack, Player player) {
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        containerItem = containerItem.updateOpen(stack, true);
        containerItem.updateSlot(stack, player.getInventory().selected);
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackLeadBox toolbox;
        int slotId;
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        if (containerItem.open() && (slotId = containerItem.slot_inventory()) != itemSlot && !world.isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerLeadBox && (toolbox = (ItemStackLeadBox)((ContainerLeadBox)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
            containerItem.updateOpen(stack, false);
        }
        if (world.getGameTime() % 40L == 0L && !(player.containerMenu instanceof ContainerLeadBox)) {
            boolean rod = (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false);
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                ItemStackLeadBox box;
                ItemStack currentStack = player.getInventory().getItem(i);
                if (!(currentStack.getItem() instanceof IRadioactiveItemType) || !rod && currentStack.getItem() instanceof ItemBaseRod || !(box = (ItemStackLeadBox)this.getInventory(player, stack)).canAdd(currentStack)) continue;
                box.add(currentStack);
                player.removeEffect(IUPotion.rad);
                player.getInventory().setItem(i, ItemStack.EMPTY);
                player.containerMenu.broadcastChanges();
                box.setChanged();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext world, List<Component> tooltip, TooltipFlag flag) {
        tooltip.add((Component)Component.translatable((String)"iu.radiationbox"));
        boolean rod = (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false);
        tooltip.add((Component)Component.translatable((String)"message.text.mode_no_instrument").append(": ").append((Component)(rod ? Component.translatable((String)"message.leadbox.enable") : Component.translatable((String)"message.leadbox.disable"))));
        if (!Screen.hasShiftDown()) {
            tooltip.add((Component)Component.translatable((String)"press.lshift"));
        } else {
            tooltip.add((Component)Component.translatable((String)"iu.changemode_key").append((Component)Component.translatable((String)"iu.changemode_rcm1")).append(" + SHIFT"));
        }
        super.appendHoverText(stack, world, tooltip, flag);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackLeadBox toolbox;
        if (!player.level().isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerLeadBox && (toolbox = (ItemStackLeadBox)((ContainerLeadBox)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAndThrow(stack);
            player.closeContainer();
        }
        return true;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!world.isClientSide && !player.isShiftKeyDown()) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(world.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
            return InteractionResultHolder.success((Object)player.getItemInHand(hand));
        }
        if (!world.isClientSide && player.isShiftKeyDown()) {
            boolean rod = (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false) == false;
            stack.set(DataComponentsInit.ACTIVE, (Object)rod);
            if (rod) {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.GREEN) + Localization.translate("message.text.mode_no_instrument") + ": " + Localization.translate("message.leadbox.enable"));
            } else {
                IUCore.proxy.messagePlayer(player, String.valueOf(ChatFormatting.RED) + Localization.translate("message.text.mode_no_instrument") + ": " + Localization.translate("message.leadbox.disable"));
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    public boolean canInsert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackLeadBox box = (ItemStackLeadBox)this.getInventory(player, stack);
        boolean rod = (Boolean)stack.getOrDefault(DataComponentsInit.ACTIVE, (Object)false);
        if (stack1.getItem() instanceof IRadioactiveItemType) {
            if (!rod) {
                return !(stack1.getItem() instanceof ItemBaseRod);
            }
            return box.canAdd(stack1);
        }
        return false;
    }

    public void insert(Player player, ItemStack stack, ItemStack stack1) {
        ItemStackLeadBox box = (ItemStackLeadBox)this.getInventory(player, stack);
        box.add(stack1);
        box.setChanged();
    }
}

