/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IUCore;
import com.denfop.api.inv.IAdvInventory;
import com.denfop.api.upgrades.IUpgradeItem;
import com.denfop.api.upgrades.UpgradableProperty;
import com.denfop.blocks.ISubEnum;
import com.denfop.container.ContainerUpgrade;
import com.denfop.datacomponent.ContainerAdditionalItem;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IItemStackInventory;
import com.denfop.items.ItemMain;
import com.denfop.items.ItemStackUpgradeModules;
import com.denfop.items.bags.BagsDescription;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.IUpdatableItemStackEvent;
import com.denfop.utils.ModUtils;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemUpgradeModule<T extends Enum<T>>
extends ItemMain<T>
implements IUpgradeItem,
IItemStackInventory,
IUpdatableItemStackEvent {
    public ItemUpgradeModule(T element) {
        super(new Item.Properties(), element);
    }

    public static Type getType(int meta) {
        if (meta < 0 || meta >= Type.Values.length) {
            return null;
        }
        return Type.Values[meta];
    }

    private static Direction getDirection(ItemStack stack) {
        byte rawDir = (Byte)stack.getOrDefault(DataComponentsInit.DIRECTION, (Object)0);
        if (rawDir < 1 || rawDir > 6) {
            return null;
        }
        return Direction.values()[rawDir - 1];
    }

    private static String getSideName(ItemStack stack) {
        Direction dir = ItemUpgradeModule.getDirection(stack);
        if (dir == null) {
            return "iu.tooltip.upgrade.ejector.anyside";
        }
        switch (dir) {
            case WEST: {
                return "iu.dir.west";
            }
            case EAST: {
                return "iu.dir.east";
            }
            case DOWN: {
                return "iu.dir.bottom";
            }
            case UP: {
                return "iu.dir.top";
            }
            case NORTH: {
                return "iu.dir.north";
            }
            case SOUTH: {
                return "iu.dir.south";
            }
        }
        throw new RuntimeException("invalid dir: " + String.valueOf(dir));
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.UpgradeTab;
    }

    @Override
    public IAdvInventory getInventory(Player var1, ItemStack var2) {
        if (((ISubEnum)this.getElement()).getId() < 11) {
            return null;
        }
        return new ItemStackUpgradeModules(var1, var2);
    }

    public void save(ItemStack stack, Player player) {
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        containerItem = containerItem.updateOpen(stack, true);
        containerItem.updateSlot(stack, player.getInventory().selected);
    }

    @Override
    public void updateField(String name, CustomPacketBuffer buffer, ItemStack stack) {
    }

    public void inventoryTick(ItemStack stack, Level world, Entity entity, int itemSlot, boolean isSelected) {
        ItemStackUpgradeModules toolbox;
        int slotId;
        super.inventoryTick(stack, world, entity, itemSlot, isSelected);
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        ContainerItem containerItem = ContainerItem.getContainer(stack);
        if (containerItem.open() && (slotId = containerItem.slot_inventory()) != itemSlot && !world.isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerUpgrade && (toolbox = (ItemStackUpgradeModules)((ContainerUpgrade)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
            containerItem.updateOpen(stack, false);
        }
    }

    @Override
    public void updateEvent(int event, ItemStack stack) {
        byte event1 = (byte)event;
        stack.set(DataComponentsInit.DIRECTION, (Object)event1);
    }

    public boolean onDroppedByPlayer(@Nonnull ItemStack stack, @Nonnull Player player) {
        ItemStackUpgradeModules toolbox;
        if (!player.level().isClientSide && !stack.isEmpty() && player.containerMenu instanceof ContainerUpgrade && (toolbox = (ItemStackUpgradeModules)((ContainerUpgrade)player.containerMenu).base).isThisContainer(stack)) {
            toolbox.saveAsThrown(stack);
            player.closeContainer();
        }
        return true;
    }

    @Override
    public boolean isSuitableFor(ItemStack stack, Set<UpgradableProperty> types) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return false;
        }
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 8: {
                return types.contains((Object)UpgradableProperty.Processing);
            }
            case 2: 
            case 3: 
            case 9: {
                return types.contains((Object)UpgradableProperty.Transformer);
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                return types.contains((Object)UpgradableProperty.EnergyStorage);
            }
            case 11: {
                return types.contains((Object)UpgradableProperty.ItemExtract);
            }
            case 12: {
                return types.contains((Object)UpgradableProperty.ItemInput);
            }
            case 13: {
                return types.contains((Object)UpgradableProperty.FluidExtract);
            }
            case 14: {
                return types.contains((Object)UpgradableProperty.FluidInput);
            }
        }
        return false;
    }

    @Override
    public int getExtraTier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 0;
        }
        switch (type.ordinal()) {
            case 9: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 4;
            }
        }
        return 0;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 1.0;
        }
        switch (type.ordinal()) {
            case 8: {
                return 0.8;
            }
            case 0: {
                return 0.6;
            }
            case 1: {
                return 0.4;
            }
        }
        return 1.0;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level world, @Nonnull Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = ModUtils.get(player, hand);
        if (!player.level().isClientSide) {
            this.save(stack, player);
            CustomPacketBuffer growingBuffer = new CustomPacketBuffer(player.registryAccess());
            growingBuffer.writeByte(1);
            growingBuffer.flip();
            player.openMenu((MenuProvider)this.getInventory(player, player.getItemInHand(hand)), buf -> buf.writeBytes((ByteBuf)growingBuffer));
        }
        return InteractionResultHolder.success((Object)player.getItemInHand(hand));
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return;
        }
        super.appendHoverText(stack, world, tooltip, flag);
        switch (type.ordinal()) {
            case 0: 
            case 1: 
            case 8: {
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.overclocker.time", (Object[])new Object[]{String.format("%.2f", 100.0 * Math.pow(this.getProcessTimeMultiplier(stack), stack.getCount()))}));
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.overclocker.power", (Object[])new Object[]{String.format("%.2f", 100.0 * Math.pow(this.getEnergyDemandMultiplier(stack), stack.getCount()))}));
                break;
            }
            case 11: 
            case 13: {
                String side = ItemUpgradeModule.getSideName(stack);
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.ejector", (Object[])new Object[]{Component.translatable((String)side)}));
                if (type != Type.ejector) break;
                ArrayList<BagsDescription> bags = new ArrayList<BagsDescription>();
                List<ItemStack> stacks = ((ContainerAdditionalItem)stack.getOrDefault(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)ContainerAdditionalItem.EMPTY)).listItem();
                for (ItemStack stack1 : stacks) {
                    if (stack1.isEmpty()) continue;
                    bags.add(new BagsDescription(stack1));
                }
                for (BagsDescription description : bags) {
                    tooltip.add((Component)Component.literal((String)description.getStack().getHoverName().getString()).withStyle(ChatFormatting.GREEN));
                }
                break;
            }
            case 12: 
            case 14: {
                String side = ItemUpgradeModule.getSideName(stack);
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.pulling", (Object[])new Object[]{Component.translatable((String)side)}));
                if (type != Type.pulling) break;
                ArrayList<BagsDescription> bags = new ArrayList<BagsDescription>();
                List<ItemStack> stacks = ((ContainerAdditionalItem)stack.getOrDefault(DataComponentsInit.CONTAINER_ADDITIONAL, (Object)ContainerAdditionalItem.EMPTY)).listItem();
                for (ItemStack stack1 : stacks) {
                    if (stack1.isEmpty()) continue;
                    bags.add(new BagsDescription(stack1));
                }
                for (BagsDescription description : bags) {
                    tooltip.add((Component)Component.literal((String)description.getStack().getHoverName().getString()).withStyle(ChatFormatting.GREEN));
                }
                break;
            }
            case 2: 
            case 3: 
            case 9: {
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.transformer", (Object[])new Object[]{this.getExtraTier(stack) * stack.getCount()}));
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                tooltip.add((Component)Component.translatable((String)"iu.tooltip.upgrade.storage", (Object[])new Object[]{this.getExtraEnergyStorage(stack) * (double)ModUtils.getSize(stack)}));
            }
        }
    }

    @Override
    public double getExtraEnergyStorage(ItemStack stack) {
        Types type = (Types)this.getElement();
        if (type == null) {
            return 0.0;
        }
        switch (type.ordinal()) {
            case 10: {
                return 10000.0;
            }
            case 4: {
                return 100000.0;
            }
            case 5: {
                return 1000000.0;
            }
            case 6: {
                return 1.0E7;
            }
            case 7: {
                return 1.0E8;
            }
        }
        return 0.0;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack itemStack) {
        Type type = ItemUpgradeModule.getType(((ISubEnum)this.getElement()).getId());
        if (type == null) {
            return 1.0;
        }
        switch (type.ordinal()) {
            case 8: {
                return 1.11;
            }
            case 0: {
                return 1.3;
            }
            case 1: {
                return 1.5;
            }
        }
        return 1.0;
    }

    public static enum Type {
        Overclocker1,
        Overclocker2,
        transformer,
        transformer1,
        storage,
        adv_storage,
        imp_storage,
        per_storage,
        overclocker,
        transformer_simple,
        energy_storage,
        ejector,
        pulling,
        fluid_ejector,
        fluid_pulling;

        public static final Type[] Values;

        static {
            Values = Type.values();
        }
    }

    public static enum Types implements ISubEnum
    {
        overclockerUpgrade1(0),
        overclockerUpgrade2(1),
        transformerUpgrade1(2),
        transformerUpgrade2(3),
        storageUpgrade(4),
        adv_storageUpgrade(5),
        imp_storageUpgrade(6),
        per_storageUpgrade(7),
        overclocker(8),
        transformer(9),
        energy_storage(10),
        ejector(11),
        pulling(12),
        fluid_ejector(13),
        fluid_pulling(14);

        private final String name = this.name().toLowerCase();
        private final int ID;

        private Types(int ID) {
            this.ID = ID;
        }

        public static Types getFromID(int ID) {
            return Types.values()[ID % Types.values().length];
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getMainPath() {
            return "upgrades";
        }

        @Override
        public int getId() {
            return this.ID;
        }
    }
}

