/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.CapabilityFluidHandlerItem;
import com.denfop.items.ItemFluidContainer;
import com.denfop.utils.FluidHandlerFix;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemReinforcedFluidCell
extends ItemFluidContainer
implements IItemTab {
    public ItemReinforcedFluidCell() {
        super(new Item.Properties().stacksTo(1).setNoRepair(), 10000);
    }

    @Override
    public boolean canfill(Fluid fluid) {
        return true;
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.fluidCellTab;
    }

    @Override
    public void fillItemCategory(CreativeModeTab p_41391_, NonNullList<ItemStack> p_41392_) {
        if (this.allowedIn(p_41391_)) {
            p_41392_.addAll(this.getAllStacks());
        }
    }

    @Override
    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext level, List<Component> list, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, level, list, tooltipFlag);
    }

    @Override
    public IFluidHandlerItem initCapabilities(ItemStack stack) {
        return new CapabilityFluidHandlerItem(() -> (DataComponentType)DataComponentsInit.FLUID.get(), stack, 10000){

            public boolean canFillFluidType(FluidStack fluid) {
                return !fluid.isEmpty() && ItemReinforcedFluidCell.this.canfill(fluid.getFluid());
            }

            public boolean canDrainFluidType(FluidStack fluid) {
                return !fluid.isEmpty() && ItemReinforcedFluidCell.this.canfill(fluid.getFluid());
            }

            public int fill(FluidStack resource, IFluidHandler.FluidAction doFill) {
                if (resource.isEmpty()) {
                    return 0;
                }
                return super.fill(resource, doFill);
            }

            @NotNull
            public FluidStack drain(int maxDrain, IFluidHandler.FluidAction doDrain) {
                return super.drain(maxDrain, doDrain);
            }

            @NotNull
            public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction doDrain) {
                if (resource == FluidStack.EMPTY) {
                    return FluidStack.EMPTY;
                }
                return super.drain(resource, doDrain);
            }

            @NotNull
            public ItemStack getContainer() {
                return this.getFluid() == FluidStack.EMPTY ? new ItemStack((ItemLike)this.container.getItem()) : this.container;
            }
        };
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.getItemInHand(hand);
        IFluidHandlerItem fs = (IFluidHandlerItem)itemstack.getCapability(Capabilities.FluidHandler.ITEM, null);
        BlockHitResult blockhitresult = ItemReinforcedFluidCell.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)(fs.getFluidInTank(0).getFluid() == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE));
        if (blockhitresult.getType() == HitResult.Type.MISS) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        if (blockhitresult.getType() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.pass((Object)itemstack);
        }
        BlockPos blockpos = blockhitresult.getBlockPos();
        Direction direction = blockhitresult.getDirection();
        BlockPos blockpos1 = blockpos.relative(direction);
        if (world.mayInteract(player, blockpos) && player.mayUseItemAt(blockpos1, direction, itemstack)) {
            BlockState state;
            BlockState blockState = state = fs.getFluidInTank(0).isEmpty() ? world.getBlockState(blockpos) : world.getBlockState(blockpos1);
            if (fs.getFluidInTank(0).getFluid() != Fluids.EMPTY && !state.liquid() && fs.getFluidInTank(0).getAmount() >= 1000) {
                BlockPos blockpos2;
                Fluid fluid = fs.getFluidInTank(0).getFluid();
                boolean flag1 = world.getBlockState(blockpos).canBeReplaced();
                BlockPos blockPos = blockpos2 = flag1 && blockhitresult.getDirection() == Direction.UP ? blockpos : blockpos.offset(blockhitresult.getDirection().getNormal());
                if (this.tryPlaceContainedLiquid(new FluidStack(fluid, 1000), player, world, blockpos2)) {
                    fs.drain(1000, IFluidHandler.FluidAction.EXECUTE);
                    return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide);
                }
            } else if (state.liquid()) {
                FluidState fluidState = state.getFluidState();
                if (!fluidState.isSource()) {
                    return InteractionResultHolder.fail((Object)itemstack);
                }
                FluidStack ret = new FluidStack(fluidState.getType(), 1000);
                FluidHandlerFix.getFluidHandler(itemstack).fill(ret, IFluidHandler.FluidAction.EXECUTE);
                world.setBlock(blockpos1, Blocks.AIR.defaultBlockState(), 3);
                return InteractionResultHolder.sidedSuccess((Object)itemstack, (boolean)world.isClientSide);
            }
        }
        return InteractionResultHolder.fail((Object)itemstack);
    }

    public boolean tryPlaceContainedLiquid(FluidStack fs, @javax.annotation.Nullable Player player, Level worldIn, BlockPos posIn) {
        Block containedBlock = fs.getFluid() == Fluids.WATER ? Blocks.WATER : (fs.getFluid() == Fluids.LAVA ? Blocks.LAVA : fs.getFluid().defaultFluidState().createLegacyBlock().getBlock());
        if (containedBlock == Blocks.AIR) {
            return false;
        }
        BlockState iblockstate = worldIn.getBlockState(posIn);
        boolean flag1 = iblockstate.canBeReplaced();
        if (iblockstate.liquid()) {
            return false;
        }
        if (!iblockstate.isAir() && !flag1) {
            return false;
        }
        if (worldIn.dimension() == Level.NETHER && containedBlock == Blocks.WATER) {
            int l = posIn.getX();
            int i = posIn.getY();
            int j = posIn.getZ();
            worldIn.playSound(player, posIn, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.6f + (worldIn.random.nextFloat() - worldIn.random.nextFloat()) * 0.8f);
            for (int k = 0; k < 8; ++k) {
                worldIn.addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, (double)l + Math.random(), (double)i + Math.random(), (double)j + Math.random(), 0.0, 0.0, 0.0);
            }
        } else {
            if (!worldIn.isClientSide && flag1 && !iblockstate.liquid()) {
                worldIn.destroyBlock(posIn, true);
            }
            SoundEvent soundevent = containedBlock == Blocks.LAVA ? SoundEvents.BUCKET_EMPTY_LAVA : SoundEvents.BUCKET_EMPTY;
            worldIn.playSound(player, posIn, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
            worldIn.setBlock(posIn, fs.getFluid().defaultFluidState().createLegacyBlock(), 11);
        }
        fs.grow(-1000);
        return true;
    }
}

