/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.IItemTab;
import com.denfop.IUCore;
import com.denfop.Localization;
import com.denfop.api.brewage.EnumBeerVariety;
import com.denfop.api.brewage.EnumTimeVariety;
import com.denfop.api.brewage.EnumWaterVariety;
import com.denfop.datacomponent.BeerInfo;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.IProperties;
import com.denfop.utils.Timer;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemBooze
extends Item
implements IProperties,
IItemTab {
    public int[] baseDuration = new int[]{300, 900, 1200, 1600, 2000, 2400};
    public float[] baseIntensity = new float[]{0.4f, 0.75f, 1.0f, 1.5f, 2.0f};
    private String nameItem;

    public ItemBooze() {
        super(new Item.Properties().stacksTo(1).setNoRepair());
        IUCore.proxy.addProperties(this);
    }

    @Override
    public CreativeModeTab getItemCategory() {
        return IUCore.ItemTab;
    }

    @Override
    public void fillItemCategory(@Nonnull CreativeModeTab tab, @Nonnull NonNullList<ItemStack> items) {
        if (this.allowedIn(tab)) {
            items.add((Object)new ItemStack((ItemLike)this).copy());
            for (EnumWaterVariety waterVariety : EnumWaterVariety.values()) {
                for (EnumTimeVariety timeVariety : EnumTimeVariety.values()) {
                    for (EnumBeerVariety beerVariety : EnumBeerVariety.values()) {
                        ItemStack stack = new ItemStack((ItemLike)this);
                        BeerInfo beerInfo = new BeerInfo(waterVariety, timeVariety, beerVariety, 5);
                        stack.set(DataComponentsInit.BEER, (Object)beerInfo);
                        items.add((Object)stack);
                    }
                }
            }
        }
    }

    protected String getOrCreateDescriptionId() {
        if (this.nameItem == null) {
            StringBuilder pathBuilder = new StringBuilder(Util.makeDescriptionId((String)"iu", (ResourceLocation)BuiltInRegistries.ITEM.getKey((Object)this)));
            String targetString = "industrialupgrade.";
            String replacement = "";
            if (replacement != null) {
                int index = pathBuilder.indexOf(targetString);
                while (index != -1) {
                    pathBuilder.replace(index, index + targetString.length(), replacement);
                    index = pathBuilder.indexOf(targetString, index + replacement.length());
                }
            }
            this.nameItem = pathBuilder.toString();
        }
        return this.nameItem;
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        player.startUsingItem(hand);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)player.getItemInHand(hand));
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity living) {
        if (!stack.has(DataComponentsInit.BEER)) {
            return new ItemStack((ItemLike)this);
        }
        BeerInfo beerInfo = (BeerInfo)stack.get(DataComponentsInit.BEER);
        EnumWaterVariety waterVariety = beerInfo.waterVariety();
        EnumTimeVariety timeVariety = beerInfo.timeVariety();
        EnumBeerVariety beerVariety = beerInfo.beerVariety();
        if (timeVariety == EnumTimeVariety.BLACK_STUFF || waterVariety == EnumWaterVariety.BLACK_STUFF || beerVariety == EnumBeerVariety.BLACKSTUFF) {
            return this.drinkBlackStuff(living);
        }
        int solidRatio = waterVariety.ordinal();
        int level = beerVariety.ordinal();
        int duration = this.baseDuration[solidRatio];
        float intensity = this.baseIntensity[timeVariety.ordinal()];
        if (living instanceof Player) {
            ((Player)living).getFoodData().eat(5 - level, (float)solidRatio * 0.15f);
        }
        int max = (int)(intensity * (float)level * 0.5f);
        MobEffectInstance slow = living.getEffect(MobEffects.DIG_SLOWDOWN);
        level = -1;
        if (slow != null) {
            level = slow.getAmplifier();
        }
        beerInfo = beerInfo.updateAmount(stack);
        this.amplifyEffect(living, (Holder<MobEffect>)MobEffects.DIG_SLOWDOWN, max, intensity, duration);
        if (level > -1) {
            this.amplifyEffect(living, (Holder<MobEffect>)MobEffects.DAMAGE_BOOST, max, intensity, duration);
            if (level > 0) {
                this.amplifyEffect(living, (Holder<MobEffect>)MobEffects.MOVEMENT_SLOWDOWN, max / 2, intensity, duration);
                if (level > 1) {
                    this.amplifyEffect(living, (Holder<MobEffect>)MobEffects.DAMAGE_RESISTANCE, max - 1, intensity, duration);
                    if (level > 2) {
                        this.amplifyEffect(living, (Holder<MobEffect>)MobEffects.CONFUSION, 0, intensity, duration);
                        if (level > 3) {
                            living.addEffect(new MobEffectInstance(MobEffects.HARM, 1, world.random.nextInt(3)));
                        }
                    }
                }
            }
        }
        return beerInfo != null ? stack : new ItemStack((ItemLike)this);
    }

    public void amplifyEffect(LivingEntity living, Holder<MobEffect> effect, int max, float intensity, int duration) {
        MobEffectInstance eff = living.getEffect(effect);
        if (eff == null) {
            living.addEffect(new MobEffectInstance(effect, duration, 0));
        } else {
            int currentDuration = eff.getDuration();
            int maxNewDuration = (int)(((float)duration * (1.0f + intensity * 2.0f) - (float)currentDuration) / 2.0f);
            if (maxNewDuration < 0) {
                maxNewDuration = 0;
            }
            if (maxNewDuration < duration) {
                duration = maxNewDuration;
            }
            currentDuration += duration;
            int newAmp = eff.getAmplifier();
            if (newAmp < max) {
                ++newAmp;
            }
            living.addEffect(new MobEffectInstance(effect, currentDuration, newAmp));
        }
    }

    public ItemStack drinkBlackStuff(LivingEntity living) {
        switch (living.getCommandSenderWorld().random.nextInt(6)) {
            case 1: {
                living.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 1200, 0));
                break;
            }
            case 2: {
                living.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 2400, 0));
                break;
            }
            case 3: {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 2400, 0));
                break;
            }
            case 4: {
                living.addEffect(new MobEffectInstance(MobEffects.POISON, 200, 2));
                break;
            }
            case 5: {
                living.addEffect(new MobEffectInstance(MobEffects.HARM, 1, living.getCommandSenderWorld().random.nextInt(4)));
            }
        }
        return new ItemStack((ItemLike)this);
    }

    public void appendHoverText(ItemStack stack, @Nullable Item.TooltipContext worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (stack.has(DataComponentsInit.BEER)) {
            BeerInfo beerInfo = (BeerInfo)stack.get(DataComponentsInit.BEER);
            EnumWaterVariety waterVariety = beerInfo.waterVariety();
            EnumTimeVariety timeVariety = beerInfo.timeVariety();
            EnumBeerVariety beerVariety = beerInfo.beerVariety();
            tooltip.add((Component)Component.literal((String)Localization.translate("iu.beer.recipe.info")));
            tooltip.add((Component)Component.literal((String)Localization.translate("iu.beer.recipe")));
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.beer.recipe1") + " " + String.valueOf(beerVariety.getRatioOfComponents().get(0).getB()))));
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.beer.recipe2") + " " + String.valueOf(beerVariety.getRatioOfComponents().get(0).getA()))));
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.beer.recipe3") + " " + String.valueOf(waterVariety.getAmount().get(0)))));
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.beer.recipe4") + " " + new Timer((int)(timeVariety.getTime() * 60.0 * 60.0)).getDisplay())));
            tooltip.add((Component)Component.literal((String)(Localization.translate("iu.beer.recipe5") + " " + waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name())));
        }
    }

    public int getUseDuration(ItemStack p_41454_, LivingEntity p_344979_) {
        return 32;
    }

    public Component getName(ItemStack stack) {
        if (!stack.has(DataComponentsInit.BEER)) {
            return Component.literal((String)Localization.translate(this.getDescriptionId(stack).replace("item.", "iu.") + ".name"));
        }
        BeerInfo beerInfo = (BeerInfo)stack.get(DataComponentsInit.BEER);
        EnumWaterVariety waterVariety = beerInfo.waterVariety();
        EnumTimeVariety timeVariety = beerInfo.timeVariety();
        EnumBeerVariety beerVariety = beerInfo.beerVariety();
        return Component.literal((String)(waterVariety.name() + " " + beerVariety.name() + " " + timeVariety.name()));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return stack.has(DataComponentsInit.BEER) ? UseAnim.DRINK : UseAnim.NONE;
    }

    @Override
    public String[] properties() {
        return new String[]{"time_variety"};
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float getItemProperty(ItemStack itemStack, ClientLevel level, LivingEntity entity, int p174679, String property) {
        boolean hasKey = itemStack.has(DataComponentsInit.BEER);
        if (!hasKey) {
            return 0.0f;
        }
        EnumTimeVariety timeVariety = ((BeerInfo)itemStack.get(DataComponentsInit.BEER)).timeVariety();
        return timeVariety.ordinal() + 1;
    }
}

