/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.items;

import com.denfop.container.ContainerHandHeldInventory;
import com.denfop.datacomponent.ContainerItem;
import com.denfop.datacomponent.DataComponentsInit;
import com.denfop.items.FacadeItemInventory;
import com.denfop.utils.ModUtils;
import java.util.Objects;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class ContainerFacadeItem
extends ContainerHandHeldInventory<FacadeItemInventory> {
    private final int current;

    public ContainerFacadeItem(Player player, FacadeItemInventory facadeItemInventory) {
        super(facadeItemInventory, player);
        this.addSlotToContainer(new Slot(this, facadeItemInventory, 0, 80, 55){

            public boolean mayPlace(ItemStack p_40231_) {
                return Block.byItem((Item)p_40231_.getItem()) != Blocks.AIR;
            }
        });
        this.current = player.getInventory().selected;
        this.addPlayerInventorySlots(player.getInventory(), 233);
    }

    @Override
    protected void addPlayerInventorySlots(Player player, int width, int height) {
        int col;
        int xStart = (width - 162) / 2;
        for (col = 0; col < 3; ++col) {
            for (int col1 = 0; col1 < 9; ++col1) {
                this.addSlotToContainer(new Slot((Container)player.getInventory(), col1 + col * 9 + 9, xStart + col1 * 18, height + -82 + col * 18));
            }
        }
        for (col = 0; col < 9; ++col) {
            this.addSlotToContainer(new Slot((Container)player.getInventory(), col, xStart + col * 18, height + -24));
        }
    }

    @Override
    public void clicked(int slot, int button, ClickType type, Player player) {
        ItemStack held;
        if (slot >= 0 && slot < this.slots.size() && ((FacadeItemInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) {
            return;
        }
        boolean closeGUI = false;
        block0 : switch (type) {
            case CLONE: 
            case PICKUP_ALL: 
            case QUICK_CRAFT: {
                break;
            }
            case PICKUP: 
            case THROW: {
                if (slot < 0 || slot >= this.slots.size()) break;
                closeGUI = ((FacadeItemInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                break;
            }
            case QUICK_MOVE: {
                if (slot < 0 || slot >= this.slots.size() || !((FacadeItemInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem())) break;
                this.setCarried(ModUtils.emptyStack);
                break;
            }
            case SWAP: {
                if (button == this.current) {
                    this.setCarried(ItemStack.EMPTY);
                    return;
                }
                assert (this.getSlotFromInventory((Container)player.getInventory(), button) != null);
                boolean swapOut = ((FacadeItemInventory)this.base).isThisContainer(this.getSlotFromInventory((Container)player.getInventory(), button).getItem());
                boolean swapTo = ((FacadeItemInventory)this.base).isThisContainer(((Slot)this.slots.get(slot)).getItem());
                if (!swapOut && !swapTo) break;
                for (int i = 0; i < 9; ++i) {
                    if ((!swapOut || slot != Objects.requireNonNull(this.getSlotFromInventory((Container)player.getInventory(), (int)i)).index) && (!swapTo || button != i)) continue;
                    if (!(player instanceof ServerPlayer)) break block0;
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    serverPlayer.connection.send((Packet)new ClientboundSetCarriedItemPacket(i));
                    break block0;
                }
                break;
            }
            default: {
                throw new RuntimeException("Unexpected ClickType: " + String.valueOf(type));
            }
        }
        ItemStack stack = this.slotClick1(slot, button, type, player);
        if (closeGUI && !player.level().isClientSide()) {
            ((FacadeItemInventory)this.base).saveAsThrown(stack);
            player.closeContainer();
        } else if (type == ClickType.CLONE && ((FacadeItemInventory)this.base).isThisContainer(held = player.getInventory().getSelected())) {
            ((ContainerItem)held.get(DataComponentsInit.CONTAINER)).updateUUID(held, 0);
        }
        this.setCarried(stack);
    }

    public ItemStack slotClick1(int slotId, int dragType, ClickType clickType, Player player) {
        super.clicked(slotId, dragType, clickType, player);
        return this.getCarried();
    }
}

