/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.invslot;

import com.denfop.IUItem;
import com.denfop.api.recipe.ISlotInv;
import com.denfop.invslot.InvSlot;
import com.denfop.items.ItemSolidMatter;
import com.denfop.tiles.base.TileConverterSolidMatter;
import com.denfop.tiles.base.TileEntityInventory;
import net.minecraft.world.item.ItemStack;

public class InvSlotConverterSolidMatter
extends InvSlot
implements ISlotInv {
    public InvSlotConverterSolidMatter(TileEntityInventory base1) {
        super(base1, InvSlot.TypeItemSlot.INPUT, 8);
    }

    @Override
    public ItemStack set(int index, ItemStack content) {
        super.set(index, content);
        this.getmatter();
        TileConverterSolidMatter tile = (TileConverterSolidMatter)this.base;
        if (tile.getRecipeOutput() != null) {
            tile.getrequiredmatter(tile.getRecipeOutput().getRecipe().getOutput());
        }
        return content;
    }

    public void getmatter() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).isEmpty()) continue;
            TileConverterSolidMatter tile = (TileConverterSolidMatter)this.base;
            int meta = IUItem.matter.getMeta(this.get(i));
            while (!this.get(i).isEmpty() && tile.quantitysolid[meta % tile.quantitysolid.length] <= 99800.0) {
                int n = meta % tile.quantitysolid.length;
                tile.quantitysolid[n] = tile.quantitysolid[n] + 200.0;
                this.consume(i, 1);
            }
        }
    }

    @Override
    public boolean acceptAllOrIndex() {
        return false;
    }

    @Override
    public boolean accepts(ItemStack itemStack, int index) {
        return itemStack.getItem() instanceof ItemSolidMatter && index == IUItem.matter.getMeta(itemStack);
    }

    public void consume(int content, int amount) {
        this.consume(content, amount, false);
    }

    public void consume(int content, int amount, boolean simulate) {
        ItemStack stack = this.get(content);
        if (!stack.isEmpty() && amount > 0) {
            int currentAmount = Math.min(amount, stack.getCount());
            if (!simulate) {
                stack.shrink(currentAmount);
            }
        }
    }

    @Override
    public boolean accepts(int index, ItemStack stack) {
        return index == IUItem.matter.getMeta(stack);
    }
}

