/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.worldcollector.aqua;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.item.ItemStack;

public class AquaHandler {
    private static final List<AquaHandler> recipes = new ArrayList<AquaHandler>();
    private final ItemStack input;
    private final ItemStack output;
    private final double need;

    public AquaHandler(ItemStack input, ItemStack output, double need) {
        this.input = input;
        this.output = output;
        this.need = need;
    }

    public static List<AquaHandler> getRecipes() {
        if (recipes.isEmpty()) {
            AquaHandler.initRecipes();
        }
        return recipes;
    }

    public static AquaHandler addRecipe(ItemStack input, ItemStack output, double need) {
        AquaHandler recipe = new AquaHandler(input, output, need);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static AquaHandler getRecipe(ItemStack is) {
        if (is == null || is.isEmpty()) {
            return null;
        }
        for (AquaHandler recipe : recipes) {
            if (!recipe.matchesInput(is)) continue;
            return recipe;
        }
        return null;
    }

    public static void initRecipes() {
        for (BaseMachineRecipe container : Recipes.recipes.getRecipeList("aquacollector")) {
            AquaHandler.addRecipe(container.input.getInputs().get(0).getInputs().get(0), container.getOutput().items.get(0), container.getOutput().metadata.getDouble("need"));
        }
    }

    public double getNeed() {
        return this.need;
    }

    public ItemStack getInput() {
        return this.input;
    }

    public ItemStack getOutput() {
        return this.output.copy();
    }

    public boolean matchesInput(ItemStack is) {
        return true;
    }
}

