/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.vein;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.vein.VeinHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityUpgradeMachineFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.fluids.FluidStack;

public class VeinCategory
extends GuiIU
implements IRecipeCategory<VeinHandler> {
    private final IDrawableStatic bg;
    JeiInform jeiInform;

    public VeinCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityUpgradeMachineFactory)BlockBaseMachine3.upgrade_machine.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/common3.png"), 3, 3, 200, 150);
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
    }

    public RecipeType<VeinHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.oilquarry).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(VeinHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        this.drawSplitString(stack, Localization.translate("iu.vein.info") + ". " + Localization.translate("iu.vein.info1") + ". " + Localization.translate("iu.vein.info2") + ". " + Localization.translate("iu.vein.info3") + ". " + Localization.translate("iu.vein.info4") + ". " + Localization.translate("iu.vein.info5"), 6, 14, 195, 0x404040);
    }

    public List<ItemStack> getInputs() {
        int i;
        ArrayList<ItemStack> stack = new ArrayList<ItemStack>();
        for (i = 0; i < 16; ++i) {
            stack.add(ItemStackHelper.fromData(IUItem.heavyore, 1, i));
        }
        for (i = 0; i < 14; ++i) {
            stack.add(ItemStackHelper.fromData(IUItem.mineral, 1, i));
        }
        stack.add(ItemStackHelper.fromData(IUItem.oilblock));
        return stack;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, VeinHandler recipe, IFocusGroup focuses) {
        List<FluidStack> fluids = Arrays.asList(new FluidStack((Fluid)FluidName.fluidneft.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidgas.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_heavy_oil.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_medium_oil.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsour_light_oil.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsweet_medium_oil.getInstance().get(), 1000), new FluidStack((Fluid)FluidName.fluidsweet_heavy_oil.getInstance().get(), 1000));
        fluids.forEach(fluidStack -> builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addFluidStack(fluidStack.getFluid(), (long)fluidStack.getAmount()));
        builder.addInvisibleIngredients(RecipeIngredientRole.OUTPUT).addItemStacks(this.getInputs());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guivein.png");
    }
}

