/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.reversetransriptor;

import com.denfop.api.Recipes;
import com.denfop.api.recipe.BaseFluidMachineRecipe;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.neoforge.fluids.FluidStack;

public class ReverseTransriptorHandler {
    private static final List<ReverseTransriptorHandler> recipes = new ArrayList<ReverseTransriptorHandler>();
    private final FluidStack input;
    private final FluidStack output;

    public ReverseTransriptorHandler(FluidStack input, FluidStack output) {
        this.input = input;
        this.output = output;
    }

    public static List<ReverseTransriptorHandler> getRecipes() {
        if (recipes.isEmpty()) {
            ReverseTransriptorHandler.initRecipes();
        }
        return recipes;
    }

    public static ReverseTransriptorHandler addRecipe(FluidStack input, FluidStack output) {
        ReverseTransriptorHandler recipe = new ReverseTransriptorHandler(input, output);
        if (recipes.contains(recipe)) {
            return null;
        }
        recipes.add(recipe);
        return recipe;
    }

    public static void initRecipes() {
        for (BaseFluidMachineRecipe container : Recipes.recipes.getRecipeFluid().getRecipeList("reverse_transcriptor")) {
            ReverseTransriptorHandler.addRecipe(container.input.getInputs().get(0), container.getOutput_fluid().get(0));
        }
    }

    public FluidStack getInput() {
        return this.input;
    }

    public FluidStack getOutput() {
        return this.output;
    }
}

