/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.handlerho;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine1;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.handlerho.HandlerHOHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.base.TileBaseHandlerHeavyOre;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class HandlerHOCategory
extends GuiIU
implements IRecipeCategory<HandlerHOHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int energy = 0;
    private int progress = 0;

    public HandlerHOCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileBaseHandlerHeavyOre)BlockBaseMachine1.handler_ho.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guihandlerho.png"), 3, 3, 140, 80);
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine, 1, 12).getDescriptionId());
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(HandlerHOHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        int xScale = 40 * this.progress / 100;
        if (xScale > 40) {
            this.progress = 0;
        }
        int size = recipe.getOutput().size();
        int y = 17;
        int x = 128;
        short temp = recipe.nbt.getShort("temperature");
        for (int i = 0; i < size; ++i) {
            this.drawSplitString(stack, recipe.nbt.getInt("input" + i) + "%", x, y, 140 - x, 0x404040);
            y += 19;
        }
        this.draw(stack, temp + "\u00b0C", 62, 75, 0x404040);
        HandlerHOCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 59, 34, 178, 34, xScale + 1, 14);
    }

    public RecipeType<HandlerHOHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, HandlerHOHandler recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 34, 33).addItemStack(recipe.getInput());
        for (int i = 0; i < recipe.getOutput().size(); ++i) {
            builder.addSlot(RecipeIngredientRole.OUTPUT, 108, 15 + 18 * i).addItemStack(recipe.getOutput().get(i));
        }
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guihandlerho.png");
    }
}

