/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.integration.jei.enrichment;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.blocks.mechanism.BlockBaseMachine3;
import com.denfop.gui.GuiIU;
import com.denfop.integration.jei.IRecipeCategory;
import com.denfop.integration.jei.JeiInform;
import com.denfop.integration.jei.enrichment.EnrichHandler;
import com.denfop.recipes.ItemStackHelper;
import com.denfop.tiles.mechanism.TileEntityEnchanterBooks;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public class EnrichCategory
extends GuiIU
implements IRecipeCategory<EnrichHandler> {
    private final IDrawableStatic bg;
    private final JeiInform jeiInform;
    private int progress = 0;
    private int energy = 0;

    public EnrichCategory(IGuiHelper guiHelper, JeiInform jeiInform) {
        super(((TileEntityEnchanterBooks)BlockBaseMachine3.enchanter_books.getDummyTe()).getGuiContainer((Player)Minecraft.getInstance().player));
        this.jeiInform = jeiInform;
        this.title = Component.literal((String)this.getTitles());
        this.bg = guiHelper.createDrawable(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guenrichment.png"), 3, 3, 140, 75);
    }

    public RecipeType<EnrichHandler> getRecipeType() {
        return this.jeiInform.recipeType;
    }

    @Override
    @Nonnull
    public String getTitles() {
        return Localization.translate(ItemStackHelper.fromData(IUItem.basemachine, 1, 10).getDescriptionId());
    }

    public String getModName() {
        return "Industrial Upgrade";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.bg;
    }

    public void draw(EnrichHandler recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics stack, double mouseX, double mouseY) {
        ++this.progress;
        ++this.energy;
        double energylevel = Math.min(14.0f * (float)this.energy / 100.0f, 14.0f);
        double xScale = 15.0 * (double)this.progress / 100.0;
        if (xScale > 15.0) {
            this.progress = 0;
        }
        EnrichCategory.bindTexture(this.getTexture());
        this.drawTexturedModalRect(stack, 66, 33, 177, 32, (int)xScale + 1, 15);
        this.drawSplitString(stack, recipe.getRadAmount() + "\u2622", 53, 60, 135, 0x404040);
    }

    public void setRecipe(IRecipeLayoutBuilder builder, EnrichHandler recipes, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 13, 33).addItemStack(recipes.getInput());
        builder.addSlot(RecipeIngredientRole.INPUT, 35, 33).addItemStack(recipes.getInput1());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 99, 33).addItemStack(recipes.getOutput());
        builder.addInvisibleIngredients(RecipeIngredientRole.INPUT).addItemStacks(recipes.getContainer().input.getAllStackInputs());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guenrichment.png");
    }
}

