/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.heat;

import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.energy.ConductorInfo;
import com.denfop.api.heat.HeatTick;
import com.denfop.api.heat.HeatTickList;
import com.denfop.api.heat.IHeatAcceptor;
import com.denfop.api.heat.IHeatConductor;
import com.denfop.api.heat.IHeatEmitter;
import com.denfop.api.heat.IHeatSink;
import com.denfop.api.heat.IHeatSource;
import com.denfop.api.heat.IHeatTile;
import com.denfop.api.heat.InfoCable;
import com.denfop.api.heat.Path;
import com.denfop.api.sytem.InfoTile;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;

public class HeatNetLocal {
    final HeatTickList<HeatTick<IHeatSource, Path>> senderPath = new HeatTickList();
    private final Map<BlockPos, IHeatTile> chunkCoordinatesIHeatTileMap;
    List<IHeatSource> sourceToUpdateList = new ArrayList<IHeatSource>();

    HeatNetLocal() {
        this.chunkCoordinatesIHeatTileMap = new HashMap<BlockPos, IHeatTile>();
    }

    public void addTile(IHeatTile tile1) {
        this.addTileEntity(tile1.getPos(), tile1);
    }

    public void addTile(IHeatTile tile, BlockEntity tileentity) {
        BlockPos coords = tileentity.getBlockPos();
        if (this.chunkCoordinatesIHeatTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIHeatTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof IHeatAcceptor) {
            this.onTileEntityAdded((IHeatAcceptor)tile);
        }
        if (tile instanceof IHeatSource) {
            this.senderPath.add(new HeatTick((IHeatSource)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, IHeatTile tile) {
        for (Direction dir : Direction.values()) {
            IHeatAcceptor receiver2;
            IHeatEmitter sender2;
            BlockPos pos1 = pos.offset(dir.getNormal());
            IHeatTile tile1 = this.chunkCoordinatesIHeatTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.getOpposite();
            if (tile1 instanceof IHeatEmitter && tile instanceof IHeatAcceptor) {
                sender2 = (IHeatEmitter)tile1;
                receiver2 = (IHeatAcceptor)tile;
                if (!sender2.emitsHeatTo(receiver2, dir.getOpposite()) || !receiver2.acceptsHeatFrom(sender2, inverseDirection2.getOpposite())) continue;
                tile1.AddHeatTile(tile, dir.getOpposite());
                tile.AddHeatTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof IHeatAcceptor) || !(tile instanceof IHeatEmitter) || !(sender2 = (IHeatEmitter)tile).emitsHeatTo(receiver2 = (IHeatAcceptor)tile1, dir) || !receiver2.acceptsHeatFrom(sender2, inverseDirection2)) continue;
            tile1.AddHeatTile(tile, dir.getOpposite());
            tile.AddHeatTile(tile1, dir);
        }
    }

    public void addTileEntity(BlockPos coords, IHeatTile tile) {
        if (this.chunkCoordinatesIHeatTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesIHeatTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof IHeatAcceptor) {
            this.onTileEntityAdded((IHeatAcceptor)tile);
        }
        if (tile instanceof IHeatSource) {
            this.senderPath.add(new HeatTick((IHeatSource)tile, null));
        }
    }

    public void onTileEntityAdded(IHeatAcceptor tile) {
        LinkedList<IHeatTile> tileEntitiesToCheck = new LinkedList<IHeatTile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<IHeatSource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            IHeatTile currentTileEntity = (IHeatTile)tileEntitiesToCheck.pop();
            List<InfoTile<IHeatTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            for (InfoTile<IHeatTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((IHeatTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((IHeatTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof IHeatSource) {
                    this.sourceToUpdateList.add((IHeatSource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof IHeatConductor)) continue;
                tileEntitiesToCheck.push((IHeatTile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<IHeatSource>(this.sourceToUpdateList);
    }

    private void updateRemove(BlockPos pos, IHeatTile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.offset(dir.getNormal());
            IHeatTile tile1 = this.chunkCoordinatesIHeatTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveHeatTile(tile, dir.getOpposite());
        }
    }

    public void removeTile(IHeatTile tile1) {
        this.removeTileEntity(tile1);
    }

    public void removeTileEntity(IHeatTile tile) {
        if (!this.chunkCoordinatesIHeatTileMap.containsKey(tile.getPos())) {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesIHeatTileMap.remove(coord);
        if (tile instanceof IHeatAcceptor) {
            this.removeAll(this.getSources((IHeatAcceptor)tile));
        }
        if (tile instanceof IHeatSource) {
            this.remove((IHeatSource)tile);
        }
        this.updateRemove(coord, tile);
    }

    public void emitHeatFrom(IHeatSource HeatSource, double amount, HeatTick<IHeatSource, Path> tick) {
        List<Path> HeatPaths = tick.getList();
        if (HeatPaths == null) {
            Tuple<List<Path>, LinkedList<IHeatConductor>> tuple = this.discover(HeatSource, tick);
            tick.setList((List)tuple.getA());
            tick.setConductors((LinkedList)tuple.getB());
            HeatPaths = tick.getList();
        }
        boolean allow = false;
        if (amount > 0.0) {
            for (Path HeatPath : HeatPaths) {
                double adding;
                IHeatSink HeatSink = HeatPath.target;
                double demandedHeat = HeatSink.getDemandedHeat();
                if (demandedHeat <= 0.0 || (adding = Math.min(amount, demandedHeat)) <= 0.0) continue;
                allow = allow || HeatSink.needTemperature();
                HeatSink.receivedHeat(adding);
                if (!(adding > HeatPath.min)) continue;
                for (ConductorInfo HeatConductor : HeatPath.conductors) {
                    if (!(HeatConductor.getBreakdownEnergy() < adding)) break;
                    ((IHeatConductor)this.chunkCoordinatesIHeatTileMap.get(HeatConductor.getPos())).removeConductor();
                }
            }
        }
        if (!allow) {
            HeatSource.setAllowed(false);
        }
    }

    public BlockEntity getTileFromIHeat(IHeatTile tile) {
        if (tile == null) {
            return null;
        }
        return tile.getTile();
    }

    public Tuple<List<Path>, LinkedList<IHeatConductor>> discover(IHeatSource emitter, HeatTick<IHeatSource, Path> tick) {
        LinkedList<IHeatTile> tileEntitiesToCheck = new LinkedList<IHeatTile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<IHeatConductor> set = new LinkedList<IHeatConductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            IHeatTile currentTileEntity = (IHeatTile)tileEntitiesToCheck.pop();
            List<InfoTile<IHeatTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof IHeatConductor) {
                cable = ((IHeatConductor)currentTileEntity).getHeatCable();
            }
            for (InfoTile<IHeatTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((IHeatTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((IHeatTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof IHeatSink) {
                    energyPaths.add(new Path((IHeatSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof IHeatConductor)) continue;
                IHeatConductor conductor = (IHeatConductor)validReceiver.tileEntity;
                conductor.setHeatCable(new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((IHeatTile)validReceiver.tileEntity);
            }
        }
        energyPaths = new ArrayList(energyPaths);
        int id1 = WorldBaseGen.random.nextInt();
        block2: for (Path energyPath : energyPaths) {
            IHeatTile tileEntity = energyPath.target;
            energyPath.target.getEnergyTickList().add(tick.getSource());
            Direction energyBlockLink = energyPath.targetDirection;
            tileEntity = tileEntity.getHeatTiles().get(energyBlockLink);
            if (!(tileEntity instanceof IHeatConductor)) continue;
            InfoCable cable = ((IHeatConductor)tileEntity).getHeatCable();
            while (cable != null) {
                IHeatConductor energyConductor = cable.getConductor();
                energyPath.conductors.add(energyConductor.getHeatConductor());
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                    if (energyConductor.getConductorBreakdownHeat() - 1.0 < energyPath.getMin()) {
                        energyPath.setMin(energyConductor.getConductorBreakdownHeat() - 1.0);
                    }
                }
                if ((cable = cable.getPrev()) != null) continue;
                continue block2;
            }
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<IHeatTile>> getValidReceivers(IHeatTile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            return emitter.getHeatValidReceivers();
        }
        return Collections.emptyList();
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (IHeatSource iHeatSource : this.sourceToUpdateList) {
                this.remove1(iHeatSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            for (HeatTick heatTick : this.senderPath) {
                IHeatSource entry = (IHeatSource)heatTick.getSource();
                if (entry == null) continue;
                double offered = entry.getOfferedHeat();
                if (entry.isAllowed()) {
                    this.emitHeatFrom(entry, offered, heatTick);
                    continue;
                }
                this.emitHeatFromNotAllowed(entry, offered, heatTick);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void emitHeatFromNotAllowed(IHeatSource HeatSource, double amount, HeatTick<IHeatSource, Path> tick) {
        List<Path> HeatPaths = tick.getList();
        if (HeatPaths == null) {
            Tuple<List<Path>, LinkedList<IHeatConductor>> tuple = this.discover(HeatSource, tick);
            tick.setList((List)tuple.getA());
            tick.setConductors((LinkedList)tuple.getB());
            HeatPaths = tick.getList();
        }
        for (Path HeatPath : HeatPaths) {
            double adding;
            IHeatSink HeatSink = HeatPath.target;
            double demandedHeat = HeatSink.getDemandedHeat();
            if (HeatSink.needTemperature()) {
                HeatSource.setAllowed(true);
            }
            if (demandedHeat <= 0.0 || (adding = Math.min(amount, demandedHeat)) <= 0.0) continue;
            HeatSink.receivedHeat(adding);
            if (!(adding > HeatPath.min)) continue;
            for (ConductorInfo HeatConductor : HeatPath.conductors) {
                if (!(HeatConductor.getBreakdownEnergy() < adding)) break;
                ((IHeatConductor)this.chunkCoordinatesIHeatTileMap.get(HeatConductor.getPos())).removeConductor();
            }
        }
    }

    public IHeatTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesIHeatTileMap.get(pos);
    }

    public void remove1(IHeatSource par1) {
        for (HeatTick heatTick : this.senderPath) {
            if (heatTick.getSource() != par1) continue;
            if (heatTick.getList() != null) {
                for (Path path : heatTick.getList()) {
                    path.target.getEnergyTickList().remove(heatTick.getSource());
                }
            }
            heatTick.setList(null);
            break;
        }
    }

    public void remove(IHeatSource par1) {
        HeatTick<IHeatSource, Path> heatTick = this.senderPath.removeSource(par1);
        if (heatTick != null && heatTick.getList() != null) {
            for (Path path : heatTick.getList()) {
                path.target.getEnergyTickList().remove(heatTick.getSource());
            }
        }
    }

    public void removeAll(List<HeatTick<IHeatSource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (HeatTick<IHeatSource, Path> iHeatSource : par1) {
            if (iHeatSource.getList() != null) {
                for (Path path : iHeatSource.getList()) {
                    path.target.getEnergyTickList().remove(iHeatSource.getSource());
                }
            }
            iHeatSource.setList(null);
        }
    }

    public List<HeatTick<IHeatSource, Path>> getSources(IHeatAcceptor par1) {
        if (par1 instanceof IHeatSink) {
            LinkedList<HeatTick<IHeatSource, Path>> list = new LinkedList<HeatTick<IHeatSource, Path>>();
            for (HeatTick heatTick : this.senderPath) {
                if (!((IHeatSink)par1).getEnergyTickList().contains(heatTick.getSource())) continue;
                list.add(heatTick);
            }
            return list;
        }
        if (par1 instanceof ICoolConductor) {
            LinkedList<HeatTick<IHeatSource, Path>> list = new LinkedList<HeatTick<IHeatSource, Path>>();
            for (HeatTick heatTick : this.senderPath) {
                if (!heatTick.getConductors().contains(par1)) continue;
                list.add(heatTick);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesIHeatTileMap.clear();
    }
}

