/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.Recipes;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.upgrade.UpgradeSystem;
import com.denfop.container.ContainerHeldUpgradeItem;
import com.denfop.gui.GuiIU;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiUpgradeItem<T extends ContainerHeldUpgradeItem>
extends GuiIU<ContainerHeldUpgradeItem> {
    private static final ResourceLocation background = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiblacklist.png");
    final List<ItemStack> list;
    private final String name;

    public GuiUpgradeItem(ContainerHeldUpgradeItem container, ItemStack itemStack1) {
        super(container);
        this.name = itemStack1.getDisplayName().getString();
        this.imageHeight = 125;
        this.list = ModUtils.get_blacklist_block();
        List<String> list2 = UpgradeSystem.system.getBlackList(itemStack1);
        for (String name : list2) {
            this.list.add(Recipes.inputFactory.getInput(name).getInputs().get(0));
        }
        this.componentList.clear();
        this.addElement(new ImageInterface(this, 0, 0, this.imageWidth, this.imageHeight));
        for (int i = 0; i < this.list.size(); ++i) {
            int y = i / 9;
            int x = i % 9;
            ItemStack stack = this.list.get(i);
            this.addElement(new ItemStackImage(this, 8 + x * 18, 40 + y * 18, () -> stack));
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.draw(poseStack, this.name, (this.imageWidth - this.getStringWidth(this.name)) / 2, 11, 0);
        this.draw(poseStack, Localization.translate("iu.blacklist_description"), (this.imageWidth - this.getStringWidth(Localization.translate("iu.blacklist_description"))) / 2, 21, 0);
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    protected ResourceLocation getTexture() {
        return background;
    }
}

