/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.container.ContainerSinSolarPanel;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiCore;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;

public class GuiSintezator<T extends ContainerSinSolarPanel>
extends GuiCore<ContainerSinSolarPanel> {
    private static ResourceLocation tex = ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/GUI_Sintezator_Slots.png".toLowerCase());
    private final ContainerSinSolarPanel container;

    public GuiSintezator(ContainerSinSolarPanel container) {
        super(container);
        this.container = container;
        this.imageWidth = 175;
        this.imageHeight = 174;
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        String storageString = Localization.translate("gui.SuperSolarPanel.storage") + ": ";
        String maxOutputString = Localization.translate("gui.SuperSolarPanel.maxOutput") + ": ";
        String generatingString = Localization.translate("gui.SuperSolarPanel.generating") + ": ";
        String energyPerTickString = Localization.translate("gui.SuperSolarPanel.energyPerTick");
        String tierString = Localization.translate("gui.iu.tier") + ": ";
        String maxstorage_1 = ModUtils.getString(this.container.tileentity.maxStorage);
        String maxstorage_2 = ModUtils.getString(this.container.tileentity.storage);
        String output = ModUtils.getString(this.container.tileentity.production);
        this.draw(poseStack, maxOutputString + output + " " + energyPerTickString, 54, 40, 0xCDCDCD);
        this.draw(poseStack, tierString + this.container.tileentity.machineTire, 54, 20, 0xCDCDCD);
        String generation = ModUtils.getString(this.container.tileentity.generating);
        String tooltip2 = generatingString + generation + " " + energyPerTickString;
        String tooltip = storageString + maxstorage_2 + "/" + maxstorage_1;
        ((Area)new AdvArea(this, 13, 17, 49, 32).withTooltip(tooltip)).drawForeground(poseStack, par1, par2);
        ((Area)new AdvArea(this, 26, 42, 35, 51).withTooltip(tooltip2)).drawForeground(poseStack, par1, par2);
    }

    @Override
    protected ResourceLocation getTexture() {
        return tex;
    }

    @Override
    protected void renderBg(GuiGraphics poseStack, float f, int i, int j) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiSintezator.bindTexture(tex);
        int h = this.guiLeft;
        int k = this.guiTop;
        this.drawTexturedModalRect(poseStack, h, k, 0, 0, this.imageWidth, this.imageHeight);
        if (this.container.tileentity.storage > 0.0 || this.container.tileentity.storage <= this.container.tileentity.maxStorage) {
            double l = this.container.tileentity.gaugeEnergyScaled(37.0f);
            this.drawTexturedModalRect(poseStack, h + 13, k + 17, 177, 3, (int)l, 16);
        }
        if (!this.container.tileentity.rain) {
            if (this.container.tileentity.sunIsUp) {
                this.drawTexturedModalRect(poseStack, h + 26, k + 42, 177, 35, 10, 10);
            } else {
                this.drawTexturedModalRect(poseStack, h + 26, k + 42, 187, 35, 10, 10);
            }
        } else if (this.container.tileentity.sunIsUp) {
            this.drawTexturedModalRect(poseStack, h + 26, k + 42, 198, 35, 10, 10);
        } else {
            this.drawTexturedModalRect(poseStack, h + 26, k + 42, 208, 35, 10, 10);
        }
    }
}

