/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentEmpty;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ImageInterface;
import com.denfop.api.gui.ImageScreen;
import com.denfop.api.gui.ItemImage;
import com.denfop.api.vein.Type;
import com.denfop.api.vein.VeinSystem;
import com.denfop.blocks.FluidName;
import com.denfop.blocks.IUFluid;
import com.denfop.componets.Energy;
import com.denfop.container.ContainerQuarryVein;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileQuarryVein;
import com.denfop.utils.ListInformationUtils;
import com.denfop.utils.ModUtils;
import com.google.common.base.Supplier;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BiomeTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.neoforge.common.Tags;

public class GuiQuarryVein<T extends ContainerQuarryVein>
extends GuiIU<ContainerQuarryVein> {
    public final ContainerQuarryVein container;
    public int[][] colors = new int[39][66];

    public GuiQuarryVein(ContainerQuarryVein container1) {
        super(container1, ((TileQuarryVein)container1.base).getStyle());
        this.container = container1;
        for (int x1 = 74; x1 <= 112; ++x1) {
            for (int y1 = 14; y1 <= 79; ++y1) {
                int y2 = this.getCoord(y1, ((TileQuarryVein)this.container.base).getBlockPos().getY());
                int x2 = this.getCoordX(x1, ((TileQuarryVein)this.container.base).getBlockPos().getX(), 88);
                BlockPos pos = new BlockPos(x2, y2, ((TileQuarryVein)this.container.base).getBlockPos().getZ());
                BlockState state = ((TileQuarryVein)this.container.base).getWorld().getBlockState(pos);
                this.colors[x1 - 74][y1 - 14] = this.getColor(state, ((TileQuarryVein)this.container.base).getWorld(), pos);
            }
        }
        this.imageHeight += 30;
        this.inventory.setY(this.inventory.getY() + 30);
        this.elements.add(new ImageInterface(this, 0, 0, this.imageHeight, this.imageHeight));
        this.elements.add(new ImageScreen(this, 7, 30, 60, 15));
        this.addComponent(new GuiComponent(this, 69, 28, EnumTypeComponent.BIGGEST_FRAME, new Component<ComponentEmpty>(new ComponentEmpty())));
        this.addComponent(new GuiComponent(this, 129, 58, EnumTypeComponent.ENERGY_HEIGHT, new Component<Energy>(((TileQuarryVein)this.container.base).energy)));
    }

    int getChance(Holder<Biome> biome) {
        if (biome.is(Tags.Biomes.IS_DESERT)) {
            return 65;
        }
        if (biome.is(BiomeTags.IS_OCEAN)) {
            return 60;
        }
        if (biome.is(BiomeTags.IS_DEEP_OCEAN)) {
            return 65;
        }
        if (biome.is(BiomeTags.IS_RIVER)) {
            return 50;
        }
        if (biome.is(BiomeTags.IS_SAVANNA)) {
            return 50;
        }
        return 10;
    }

    List<String> getList() {
        ArrayList<String> lst = new ArrayList<String>();
        Holder biome = ((TileQuarryVein)this.container.base).getWorld().getBiome(((TileQuarryVein)this.container.base).getBlockPos());
        ResourceLocation biomeKey = ((TileQuarryVein)this.container.base).getWorld().registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)biome.value()));
        lst.add(Localization.translate("iu.biome") + Localization.translate("biome." + biomeKey.getNamespace() + "." + biomeKey.getPath()));
        int col = biome.is(BiomeTags.IS_HILL) ? 25 : 0;
        int col1 = biome.is(BiomeTags.IS_TAIGA) || biome.is(Tags.Biomes.IS_SNOWY) ? 15 : 0;
        lst.add(Localization.translate("iu.gettingvein") + (int)((double)Math.max(0, this.getChance((Holder<Biome>)biome) - col - col1) * 0.85) + "%");
        lst.add(Localization.translate("iu.gettingvein1") + String.valueOf(15 + col) + "%");
        lst.add(Localization.translate("iu.gettingvein2") + String.valueOf(15 + col + col1) + "%");
        return lst;
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 73 && mouseX <= 113 && mouseY >= 33 && mouseY < 100) {
            int y = this.getCoord(mouseY, ((TileQuarryVein)this.container.base).getBlockPos().getY());
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.quarryveininformation"));
            List<String> compatibleUpgrades = this.getList();
            compatibleUpgrades.add("Y: " + y);
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        } else if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.quarryvein_info"));
            List<String> compatibleUpgrades = ListInformationUtils.quarryvein;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    private int getCoord(int mouseY, int y) {
        double m = (double)y * 1.0 / 59.0;
        double m1 = mouseY - 21;
        return (int)Math.min(Math.max((double)y - (m *= m1), 0.0), 256.0);
    }

    private int getCoordX(int mouseX, int x, int center) {
        int x1 = x;
        x1 = mouseX < center ? (x1 -= (center - mouseX) * 2) : (x1 += (center - mouseX) * 2);
        return x1;
    }

    private void handleUpgradeTooltip1(int mouseX, int mouseY) {
        if (mouseX >= 122 && mouseX <= 166 && mouseY >= 23 && mouseY <= 39) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.canupdate"));
            String m = "";
            switch (((TileQuarryVein)this.container.base).levelMech) {
                case 2: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine1");
                    break;
                }
                case 3: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine2");
                    break;
                }
                case 4: {
                    break;
                }
                default: {
                    m = Localization.translate("iu.upgradekitmachine.upgradepanelkitmachine");
                }
            }
            List<String> compatibleUpgrades = Collections.singletonList(m);
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            if (!m.equals("")) {
                this.drawTooltip(mouseX, mouseY, text);
            }
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        Object name = Localization.translate(((TileQuarryVein)this.container.base).getName());
        switch (((TileQuarryVein)this.container.base).levelMech) {
            case 2: {
                name = String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.advanced_name") + " " + ((String)name).toLowerCase();
                break;
            }
            case 3: {
                name = String.valueOf(ChatFormatting.BLUE) + Localization.translate("iu.improved_name") + " " + ((String)name).toLowerCase();
                break;
            }
            case 4: {
                name = String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("iu.perfect_name") + " " + ((String)name).toLowerCase();
                break;
            }
        }
        int nmPos = (this.imageWidth - this.getStringWidth((String)name)) / 2;
        this.draw(poseStack, (String)name, nmPos, 4, 0x404040);
        this.draw(poseStack, Localization.translate("iu.level"), 122, 23, 0x404040);
        switch (((TileQuarryVein)this.container.base).levelMech) {
            case 2: {
                this.draw(poseStack, String.valueOf(ChatFormatting.GOLD) + Localization.translate("iu.advanced"), 122, 31, 0x404040);
                break;
            }
            case 3: {
                this.draw(poseStack, String.valueOf(ChatFormatting.BLUE) + Localization.translate("iu.improved"), 122, 31, 0x404040);
                break;
            }
            case 4: {
                this.draw(poseStack, String.valueOf(ChatFormatting.DARK_PURPLE) + Localization.translate("iu.perfect"), 122, 31, 0x404040);
                break;
            }
            default: {
                this.draw(poseStack, Localization.translate("iu.simply"), 122, 31, 0x404040);
            }
        }
        this.handleUpgradeTooltip1(par1, par2);
        if (((TileQuarryVein)this.container.base).vein == null || ((TileQuarryVein)this.container.base).progress < 1200) {
            this.draw(poseStack, ((TileQuarryVein)this.container.base).progress * 100 / 1200 + "%", 29, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
        }
        this.handleUpgradeTooltip(par1, par2);
        if (((TileQuarryVein)this.container.base).vein != VeinSystem.system.getEMPTY() && ((TileQuarryVein)this.container.base).vein.get()) {
            if (((TileQuarryVein)this.container.base).vein.getType() == Type.EMPTY || ((TileQuarryVein)this.container.base).vein.getMaxCol() == 0) {
                this.draw(poseStack, Localization.translate("iu.empty"), 20, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
            } else {
                Object name_vein;
                boolean isOil;
                this.draw(poseStack, Localization.translate("iu.find"), 11, 34, ModUtils.convertRGBcolorToInt(13, 229, 34));
                int col = ((TileQuarryVein)this.container.base).vein.getCol();
                int colmax = ((TileQuarryVein)this.container.base).vein.getMaxCol();
                boolean bl = isOil = ((TileQuarryVein)this.container.base).vein.getType() == Type.OIL;
                if (!isOil) {
                    if (((TileQuarryVein)this.container.base).vein.getType() != Type.GAS) {
                        name_vein = ((TileQuarryVein)this.container.base).vein.isOldMineral() ? new ItemStack((ItemLike)IUItem.heavyore.getItem(((TileQuarryVein)this.container.base).vein.getMeta()), 1).getDisplayName().getString() : new ItemStack((ItemLike)IUItem.mineral.getItem(((TileQuarryVein)this.container.base).vein.getMeta()), 1).getDisplayName().getString();
                    } else {
                        name_vein = Localization.translate(((IUFluid)((Object)FluidName.fluidgas.getInstance().get())).getFluidType().getDescriptionId());
                        isOil = true;
                    }
                } else {
                    String varietyString;
                    int variety = ((TileQuarryVein)this.container.base).vein.getMeta() / 3;
                    int type = ((TileQuarryVein)this.container.base).vein.getMeta() % 3;
                    String string = varietyString = variety == 0 ? "iu.sweet_oil" : "iu.sour_oil";
                    String typeString = type == 0 ? "iu.light_oil" : (type == 1 ? "iu.medium_oil" : "iu.heavy_oil");
                    name_vein = Localization.translate(varietyString) + " " + Localization.translate(typeString) + " " + Localization.translate(new ItemStack((ItemLike)IUItem.oilblock.getItem()).getDescriptionId());
                }
                ((Area)new AdvArea(this, 20, 54, 68, 72).withTooltip((String)name_vein + " " + col + (isOil ? "mb" : "") + "/" + colmax + (isOil ? "mb" : ""))).drawForeground(poseStack, par1, par2);
            }
        }
    }

    private int getColor(BlockState state, Level world, BlockPos pos) {
        MapColor color = state.getMapColor((BlockGetter)world, pos);
        return color.col | 0xFF000000;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        int h = this.guiLeft;
        int k = this.guiTop;
        GuiQuarryVein.bindTexture(this.getTexture());
        int m = ((TileQuarryVein)this.container.base).progress * 34 / 1200;
        ShaderInstance shader = RenderSystem.getShader();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        for (int x1 = 74; x1 <= 112; ++x1) {
            for (int y1 = 14; y1 <= 79; ++y1) {
                this.drawColoredRect(poseStack, x1, y1 + 20, 1, 1, this.colors[x1 - 74][y1 - 14], bufferBuilder);
            }
        }
        BufferUploader.drawWithShader((MeshData)bufferBuilder.buildOrThrow());
        RenderSystem.setShader(() -> shader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.drawTexturedModalRect(poseStack, h + 88, k + 42, 183, 50, 1, m);
        switch (((TileQuarryVein)this.container.base).levelMech) {
            case 2: {
                this.drawTexturedModalRect(poseStack, h + 88, k + 41, 184, 48, 1, 1);
                break;
            }
            case 3: {
                this.drawTexturedModalRect(poseStack, h + 88, k + 41, 185, 48, 1, 1);
                break;
            }
            case 4: {
                this.drawTexturedModalRect(poseStack, h + 88, k + 41, 186, 48, 1, 1);
                break;
            }
        }
        GuiQuarryVein.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, h + 3, k + 3, 0, 0, 10, 10);
        GuiQuarryVein.bindTexture(this.getTexture());
        if (((TileQuarryVein)this.container.base).vein != null && ((TileQuarryVein)this.container.base).vein.get() && ((TileQuarryVein)this.container.base).vein.getType() != Type.EMPTY) {
            ItemStack stack = ((TileQuarryVein)this.container.base).vein.getType() == Type.VEIN ? (((TileQuarryVein)this.container.base).vein.isOldMineral() ? new ItemStack((ItemLike)IUItem.heavyore.getItem(((TileQuarryVein)this.container.base).vein.getMeta()), 1) : new ItemStack((ItemLike)IUItem.mineral.getItem(((TileQuarryVein)this.container.base).vein.getMeta()), 1)) : (((TileQuarryVein)this.container.base).vein.getType() == Type.OIL ? new ItemStack((ItemLike)IUItem.oilblock.getItem()) : new ItemStack((ItemLike)IUItem.gasBlock.getItem()));
            new ItemImage(this, 32, 54, (Supplier<ItemStack>)((Supplier)() -> stack)).drawBackground(poseStack, this.guiLeft, this.guiTop);
        }
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiquarryvein.png");
    }
}

