/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.container.ContainerPrimalProgrammingTable;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.mechanism.TileEntityPrimalProgrammingTable;
import com.denfop.world.WorldBaseGen;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class GuiPrimalProgrammingTable<T extends ContainerPrimalProgrammingTable>
extends GuiIU<ContainerPrimalProgrammingTable> {
    public final ContainerPrimalProgrammingTable container;
    int pointer;
    int prevPointer;
    boolean hover;

    public GuiPrimalProgrammingTable(ContainerPrimalProgrammingTable container1) {
        super(container1);
        this.container = container1;
        this.componentList.clear();
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.hover = par1 >= 7 && par2 >= 62 && par1 <= 18 && par2 <= 73;
        this.handleUpgradeTooltip(par1, par2);
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 13 && mouseY >= 3 && mouseY <= 13) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("programming_table.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 9; ++i) {
                compatibleUpgrades.add(Localization.translate("programming_table.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 60, mouseY, text);
        }
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        int value;
        int pointer1;
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        if (((TileEntityPrimalProgrammingTable)this.container.base).start && x >= 7 && y >= 62 && x <= 18 && y <= 73 && (pointer1 = this.pointer - 20) > 0 && (value = (value = ((TileEntityPrimalProgrammingTable)this.container.base).data[pointer1 % ((TileEntityPrimalProgrammingTable)this.container.base).data.length]) == 2 ? 0 : (value == 0 ? 1 : (value == 3 ? 2 : -1))) != -1) {
            SoundManager soundManager = Minecraft.getInstance().getSoundManager();
            soundManager.play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
            new PacketUpdateServerTile((BlockEntity)this.container.base, value);
            this.pointer = WorldBaseGen.random.nextInt(146) + 20;
        }
    }

    @Override
    protected void drawBackgroundAndTitle(GuiGraphics poseStack, float partialTicks, int mouseX, int mouseY) {
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, this.imageWidth, this.imageHeight);
    }

    @Override
    public void updateTickInterface() {
        if (this.pointer < 20) {
            this.pointer = 20;
            this.prevPointer = 0;
        } else if (this.pointer > 165) {
            this.pointer = 165;
            this.prevPointer = 1;
        }
        if (this.pointer < 20) {
            this.pointer = 20;
            this.prevPointer = 0;
        } else if (this.pointer >= 166) {
            this.pointer = 165;
            this.prevPointer = 1;
        }
        this.pointer = this.prevPointer == 0 ? ++this.pointer : --this.pointer;
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        int xoffset = (this.width - this.imageWidth) / 2;
        int yoffset = (this.height - this.imageHeight) / 2;
        GuiPrimalProgrammingTable.bindTexture(this.getTexture());
        int progress = (int)(34.0 * ((TileEntityPrimalProgrammingTable)this.container.base).componentProgress.getBar());
        this.drawTexturedModalRect(poseStack, this.guiLeft + 85, this.guiTop + 24, 177, 1, progress, 20);
        if (this.hover) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 7, this.guiTop + 62, 177, 32, 12, 12);
        }
        if (((TileEntityPrimalProgrammingTable)this.container.base).start) {
            int k = 0;
            for (int i : ((TileEntityPrimalProgrammingTable)this.container.base).data) {
                if (i == 1) {
                    ++k;
                    continue;
                }
                int y1 = 0;
                if (i == 0) {
                    y1 = 167;
                }
                if (i == 2) {
                    y1 = 177;
                }
                if (i == 3) {
                    y1 = 172;
                }
                this.drawTexturedModalRect(poseStack, this.guiLeft + 20 + k, this.guiTop + 66, 1 + k, y1, 1, 4);
                ++k;
            }
            this.drawTexturedModalRect(poseStack, this.guiLeft + this.pointer - 1, this.guiTop + 68, 177, 25, 4, 4);
        }
        GuiPrimalProgrammingTable.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedRect(poseStack, 3.0, 3.0, 10.0, 10.0, 0.0, 0.0);
    }

    public String getName() {
        return "";
    }

    @Override
    public ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guiprogrammingtable.png");
    }
}

