/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.ComponentEmpty;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.TankGauge;
import com.denfop.componets.ComponentButton;
import com.denfop.componets.Energy;
import com.denfop.componets.HeatComponent;
import com.denfop.container.ContainerHeatMachine;
import com.denfop.gui.GuiIU;
import com.denfop.tiles.base.TileBaseHeatMachine;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.utils.ListInformationUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.fluids.IFluidTank;

public class GuiHeatMachine<T extends ContainerHeatMachine>
extends GuiIU<ContainerHeatMachine> {
    public ContainerHeatMachine container;
    public String name;

    public GuiHeatMachine(ContainerHeatMachine guiContainer) {
        super(guiContainer);
        this.container = guiContainer;
        this.name = Localization.translate(((TileBaseHeatMachine)guiContainer.base).getName());
        if (((TileBaseHeatMachine)this.container.base).hasFluid) {
            this.componentList.add(new GuiComponent(this, 117, 41, EnumTypeComponent.FLUID_PART, new Component<ComponentEmpty>(new ComponentEmpty())));
            this.addElement(TankGauge.createNormal(this, 96, 22, (IFluidTank)((TileBaseHeatMachine)this.container.base).fluidTank));
        } else {
            this.componentList.add(new GuiComponent(this, 113, 21, EnumTypeComponent.ENERGY_HEIGHT, new Component<Energy>(((TileBaseHeatMachine)this.container.base).energy)));
        }
        this.componentList.add(new GuiComponent(this, 51, 41, EnumTypeComponent.HEAT, new Component<HeatComponent>(((TileBaseHeatMachine)this.container.base).heat)));
        this.componentList.add(new GuiComponent(this, 20, 37, EnumTypeComponent.WORK_BUTTON, new Component<1>(new ComponentButton(this, (TileEntityBlock)((Object)this.container.base), 2, ""){

            @Override
            public String getText() {
                return ((TileBaseHeatMachine)this.getEntityBlock()).work ? Localization.translate("turn_off") : Localization.translate("turn_on");
            }

            @Override
            public boolean active() {
                return !((TileBaseHeatMachine)this.getEntityBlock()).work;
            }
        })));
        this.componentList.add(new GuiComponent(this, 53, 60, EnumTypeComponent.PLUS_BUTTON, new Component<2>(new ComponentButton(this, (TileEntityBlock)((Object)this.container.base), 0, ""){

            @Override
            public String getText() {
                return "+1000";
            }
        })));
        this.componentList.add(new GuiComponent(this, 78, 60, EnumTypeComponent.MINUS_BUTTON, new Component<3>(new ComponentButton(this, (TileEntityBlock)((Object)this.container.base), 1, ""){

            @Override
            public String getText() {
                return "-1000";
            }
        })));
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 3 && mouseX <= 15 && mouseY >= 3 && mouseY <= 15) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.heat_storage.info_main"));
            List<String> compatibleUpgrades = ListInformationUtils.heating;
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX, mouseY, text);
        }
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiHeatMachine.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft + 3, this.guiTop + 3, 0, 0, 10, 10);
        GuiHeatMachine.bindTexture(this.getTexture());
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guimachine.png");
    }
}

