/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.gui;

import com.denfop.Localization;
import com.denfop.api.gui.Area;
import com.denfop.api.gui.Component;
import com.denfop.api.gui.EnumTypeComponent;
import com.denfop.api.gui.FluidItem;
import com.denfop.api.gui.GuiComponent;
import com.denfop.api.gui.ItemStackImage;
import com.denfop.api.recipe.MachineRecipe;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.container.ContainerCyclotronController;
import com.denfop.gui.AdvArea;
import com.denfop.gui.GuiIU;
import com.denfop.network.packet.PacketUpdateServerTile;
import com.denfop.tiles.cyclotron.TileEntityCyclotronController;
import com.denfop.utils.ModUtils;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;

public class GuiCyclotronController<T extends ContainerCyclotronController>
extends GuiIU<ContainerCyclotronController> {
    private boolean hover = false;

    public GuiCyclotronController(ContainerCyclotronController guiContainer) {
        super(guiContainer);
        this.componentList.clear();
    }

    @Override
    protected void mouseClicked(int i, int j, int k) {
        boolean start;
        super.mouseClicked(i, j, k);
        int xMin = (this.width - this.imageWidth) / 2;
        int yMin = (this.height - this.imageHeight) / 2;
        int x = i - xMin;
        int y = j - yMin;
        boolean bl = start = x >= 51 && x <= 68 && y >= 59 && y <= 76;
        if (start) {
            new PacketUpdateServerTile((BlockEntity)((ContainerCyclotronController)this.container).base, 0.0);
        }
    }

    private void handleUpgradeTooltip(int mouseX, int mouseY) {
        if (mouseX >= 0 && mouseX <= 12 && mouseY >= 0 && mouseY <= 12) {
            ArrayList<String> text = new ArrayList<String>();
            text.add(Localization.translate("iu.cyclotron.info"));
            ArrayList<String> compatibleUpgrades = new ArrayList<String>();
            for (int i = 1; i < 6; ++i) {
                compatibleUpgrades.add(Localization.translate("iu.cyclotron.info" + i));
            }
            for (String itemstack : compatibleUpgrades) {
                text.add(itemstack);
            }
            this.drawTooltip(mouseX - 120, mouseY, text);
        }
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(GuiGraphics poseStack, float f, int x, int y) {
        MachineRecipe output;
        super.drawGuiContainerBackgroundLayer(poseStack, f, x, y);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture();
        if (((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).progress > 0) {
            double progress = Math.min(1.0, (double)((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).progress / 1000.0);
            this.drawTexturedModalRect(poseStack, this.guiLeft + 72, this.guiTop + 31, 232, 55, (int)(23.0 * progress), 16);
        }
        new FluidItem(this, 11, 28, ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).cryogen.getCryogenTank().getFluid()){

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                1.bindCommonTexture();
                FluidStack fs = ((TileEntityCyclotronController)((ContainerCyclotronController)GuiCyclotronController.this.container).base).cryogen.getCryogenTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x + 1;
                    int fluidY = this.y + 1;
                    int fluidWidth = 10;
                    int fluidHeight = 45;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 1.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    1.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)(mouseY + fluidY) + (45.0 - (double)fluidHeight * ((double)fs.getAmount() / 10000.0)), fluidWidth, (double)(fluidHeight * fs.getAmount()) / 10000.0, sprite, color, 1.0, false, false);
                }
                1.bindTexture(commonTexture1);
            }

            @Override
            public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
                if (mouseX >= this.x - 4 && mouseX <= this.x + 15 && mouseY >= this.y - 4 && mouseY <= this.y + 51) {
                    String tooltip;
                    List<String> lines = this.getToolTip();
                    if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                        1.addLines(lines, tooltip);
                    }
                    if (!lines.isEmpty()) {
                        this.gui.drawTooltip(mouseX, mouseY, lines);
                    }
                }
            }
        }.drawBackground(poseStack, this.guiLeft, this.guiTop);
        new FluidItem(this, 33, 28, ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).coolant.getCoolantTank().getFluid()){

            @Override
            public void drawBackground(GuiGraphics poseStack, int mouseX, int mouseY) {
                2.bindCommonTexture();
                FluidStack fs = ((TileEntityCyclotronController)((ContainerCyclotronController)GuiCyclotronController.this.container).base).coolant.getCoolantTank().getFluid();
                if (!fs.isEmpty() && fs.getAmount() > 0) {
                    int fluidX = this.x + 1;
                    int fluidY = this.y + 1;
                    int fluidWidth = 10;
                    int fluidHeight = 45;
                    Fluid fluid = fs.getFluid();
                    IClientFluidTypeExtensions extensions = IClientFluidTypeExtensions.of((Fluid)fluid);
                    TextureAtlasSprite sprite = 2.getBlockTextureMap().getSprite(extensions.getStillTexture(fs));
                    int color = extensions.getTintColor();
                    2.bindBlockTexture();
                    this.gui.drawSprite(poseStack, mouseX + fluidX, (double)(mouseY + fluidY) + (45.0 - (double)fluidHeight * ((double)fs.getAmount() / 10000.0)), fluidWidth, (double)(fluidHeight * fs.getAmount()) / 10000.0, sprite, color, 1.0, false, false);
                }
                2.bindTexture(commonTexture1);
            }

            @Override
            public void drawForeground(GuiGraphics poseStack1, int mouseX, int mouseY) {
                if (mouseX >= this.x - 4 && mouseX <= this.x + 15 && mouseY >= this.y - 4 && mouseY <= this.y + 51) {
                    String tooltip;
                    List<String> lines = this.getToolTip();
                    if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                        2.addLines(lines, tooltip);
                    }
                    if (!lines.isEmpty()) {
                        this.gui.drawTooltip(mouseX, mouseY, lines);
                    }
                }
            }
        }.drawBackground(poseStack, this.guiLeft, this.guiTop);
        new ItemStackImage(this, 52, 31, () -> ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).bombardmentChamber.getInputSlot().get(0)).drawBackground(poseStack, this.guiLeft, this.guiTop);
        new ItemStackImage(this, 103, 31, () -> ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).electrostaticDeflector.getOutputSlot().get(0)).drawBackground(poseStack, this.guiLeft, this.guiTop);
        this.bindTexture();
        this.drawTexturedModalRect(poseStack, this.guiLeft + 130, this.guiTop + 26, 216, 5, (int)(35.0 * ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).positrons.getPositrons().getFillRatio()), 8);
        this.drawTexturedModalRect(poseStack, this.guiLeft + 130, this.guiTop + 44, 216, 23, (int)(35.0 * ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).quantum.getQuantum().getFillRatio()), 8);
        if (this.hover) {
            this.drawTexturedModalRect(poseStack, this.guiLeft + 51, this.guiTop + 59, 237, 36, 18, 18);
        }
        if ((output = ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).bombardmentChamber.getRecipeOutput()) != null) {
            this.draw(poseStack, String.valueOf(ChatFormatting.GREEN) + Localization.translate("chance") + output.getRecipe().output.metadata.getInt("chance") + "%", this.guiLeft + 88, this.guiTop + 63, ModUtils.convertRGBcolorToInt(217, 217, 217));
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiCyclotronController.bindTexture(ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/infobutton.png"));
        this.drawTexturedModalRect(poseStack, this.guiLeft, this.guiTop, 0, 0, 10, 10);
    }

    @Override
    protected void drawForegroundLayer(GuiGraphics poseStack, int par1, int par2) {
        super.drawForegroundLayer(poseStack, par1, par2);
        this.handleUpgradeTooltip(par1, par2);
        this.hover = par1 >= 51 && par1 <= 68 && par2 >= 59 && par2 <= 76;
        ((Area)new AdvArea(this, 72, 31, 94, 47).withTooltip((int)(Math.min(1.0, (double)((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).progress / 1000.0) * 100.0) + "%")).drawForeground(poseStack, par1, par2);
        ((Area)new AdvArea(this, 51, 59, 68, 76).withTooltip(((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).work ? Localization.translate("turn_off") : Localization.translate("turn_on"))).drawForeground(poseStack, par1, par2);
        new FluidItem(this, this, 11, 28, ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).cryogen.getCryogenTank().getFluid()){

            @Override
            public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
                if (mouseX >= this.x - 4 && mouseX <= this.x + 15 && mouseY >= this.y - 4 && mouseY <= this.y + 51) {
                    String tooltip;
                    List<String> lines = this.getToolTip();
                    if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                        3.addLines(lines, tooltip);
                    }
                    if (!lines.isEmpty()) {
                        this.gui.drawTooltip(mouseX, mouseY, lines);
                    }
                }
            }
        }.drawForeground(poseStack, par1, par2);
        new FluidItem(this, this, 33, 28, ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).coolant.getCoolantTank().getFluid()){

            @Override
            public void drawForeground(GuiGraphics poseStack, int mouseX, int mouseY) {
                if (mouseX >= this.x - 4 && mouseX <= this.x + 15 && mouseY >= this.y - 4 && mouseY <= this.y + 51) {
                    String tooltip;
                    List<String> lines = this.getToolTip();
                    if (this.getTooltipProvider() != null && (tooltip = (String)this.getTooltipProvider().get()) != null && !tooltip.isEmpty()) {
                        4.addLines(lines, tooltip);
                    }
                    if (!lines.isEmpty()) {
                        this.gui.drawTooltip(mouseX, mouseY, lines);
                    }
                }
            }
        }.drawForeground(poseStack, par1, par2);
        new GuiComponent(this, 126, 22, EnumTypeComponent.POSITRONS, new Component<ComponentBaseEnergy>(((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).positrons.getPositrons())).drawForeground(poseStack, par1, par2);
        new GuiComponent(this, 126, 40, EnumTypeComponent.QUANTUM_ENERGY_WEIGHT, new Component<ComponentBaseEnergy>(((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).quantum.getQuantum())).drawForeground(poseStack, par1, par2);
        new ItemStackImage(this, 52, 31, () -> ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).bombardmentChamber.getInputSlot().get(0)).drawForeground(poseStack, par1, par2);
        new ItemStackImage(this, 103, 31, () -> ((TileEntityCyclotronController)((ContainerCyclotronController)this.container).base).electrostaticDeflector.getOutputSlot().get(0)).drawForeground(poseStack, par1, par2);
    }

    @Override
    protected ResourceLocation getTexture() {
        return ResourceLocation.tryBuild((String)"industrialupgrade", (String)"textures/gui/guicyclotroncontroller.png");
    }
}

