/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events.client;

import com.denfop.api.guidebook.GuideBookCore;
import com.denfop.api.guidebook.GuideTab;
import com.denfop.api.guidebook.Quest;
import com.denfop.network.packet.PacketUpdateCompleteQuest;
import com.denfop.toast.GuideToast;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class EventAutoQuests {
    private static final int QUESTS_PER_TICK = 10;
    private static int tabIndex = 0;
    private static int questIndex = 0;

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onWorldTick(PlayerTickEvent.Post event) {
        List<GuideTab> guideTabs = GuideBookCore.instance.getGuideTabs();
        if (guideTabs.isEmpty()) {
            return;
        }
        Map<String, List<String>> map = GuideBookCore.uuidGuideMap.get(event.getEntity().getUUID());
        if (map == null) {
            return;
        }
        try {
            if (tabIndex >= guideTabs.size()) {
                tabIndex = 0;
            }
            GuideTab guideTab = guideTabs.get(tabIndex % guideTabs.size());
            List<Quest> quests = GuideBookCore.instance.getQuests(tabIndex % guideTabs.size());
            if (questIndex >= quests.size()) {
                questIndex = 0;
                if (++tabIndex >= guideTabs.size()) {
                    tabIndex = 0;
                }
                return;
            }
            for (int processed = 0; questIndex < quests.size() && processed < 10; ++processed) {
                boolean isUnlocked;
                Quest quest = quests.get(questIndex % quests.size());
                ++questIndex;
                List<ItemStack> stacks = this.mergeStacks(quest.itemStacks);
                boolean hasPrev = quest.hasPrev;
                List<String> completedQuests = map.get(guideTab.unLocalized);
                boolean bl = isUnlocked = hasPrev && completedQuests.contains(quest.prevName);
                if (stacks.isEmpty() || !this.isComplete(event.getEntity(), tabIndex, isUnlocked, stacks, quest)) continue;
                this.complete(event.getEntity(), tabIndex, quest);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private List<ItemStack> mergeStacks(List<ItemStack> input) {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (ItemStack stack : input) {
            boolean merged = false;
            for (ItemStack existing : stacks) {
                if (!ItemStack.isSameItem((ItemStack)existing, (ItemStack)stack)) continue;
                existing.grow(stack.getCount());
                merged = true;
                break;
            }
            if (merged) continue;
            stacks.add(stack.copy());
        }
        return stacks;
    }

    public boolean hasAllItems(Player player, List<ItemStack> requiredItems, Quest quest) {
        for (FluidStack fluidStack : quest.fluidStacks) {
            int amount = fluidStack.getAmount();
            for (int i = 0; i < player.getInventory().items.size(); ++i) {
                IFluidHandlerItem handler;
                ItemStack inInventory = (ItemStack)player.getInventory().items.get(i);
                if (FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null) == null || (handler = (IFluidHandlerItem)FluidUtil.getFluidHandler((ItemStack)inInventory).orElse(null)).getFluidInTank(0).isEmpty() || !FluidStack.isSameFluid((FluidStack)handler.getFluidInTank(0), (FluidStack)fluidStack)) continue;
                if (handler.getFluidInTank(0).getAmount() < fluidStack.getAmount()) {
                    amount -= handler.getFluidInTank(0).getAmount();
                    continue;
                }
                amount = 0;
                break;
            }
            if (amount == 0) continue;
            return false;
        }
        for (ItemStack required : requiredItems) {
            ItemStack inInventory;
            int neededCount = required.getCount();
            int foundCount = 0;
            for (int i = 0; !(i >= player.getInventory().items.size() || ItemStack.isSameItem((ItemStack)(inInventory = (ItemStack)player.getInventory().items.get(i)), (ItemStack)required) && (foundCount += inInventory.getCount()) >= neededCount); ++i) {
            }
            if (foundCount >= neededCount) continue;
            return false;
        }
        return true;
    }

    public boolean isComplete(Player player, int tab, boolean isUnlocked, List<ItemStack> stacks, Quest quest) {
        if (this.hasAllItems(player, stacks, quest) && !isUnlocked) {
            return GuideBookCore.uuidGuideMap.get(player.getUUID()).get(GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized).contains(quest.unLocalizedName);
        }
        return false;
    }

    public void complete(Player player, int tab, Quest quest) {
        Minecraft.getInstance().getToasts().addToast((Toast)new GuideToast(quest));
        new PacketUpdateCompleteQuest(player, GuideBookCore.instance.getGuideTabs().get((int)tab).unLocalized, quest.unLocalizedName);
    }
}

