/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.events;

import com.denfop.IUCore;
import com.denfop.Localization;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class EventUpdate {
    private boolean playerNotified = false;
    private int delay = 120;

    @SubscribeEvent
    public void onPlayerTick(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (!this.playerNotified) {
            this.playerNotified = true;
            this.sendModCheckMessage((Player)player2);
        }
    }

    private void sendModCheckMessage(Player player) {
        if (!player.level().isClientSide) {
            String modVersion = "3.3.1.15";
            boolean hasPowerUtilities = ModList.get().isLoaded("powerutils");
            boolean hasSimplyQuarry = ModList.get().isLoaded("simplyquarries");
            boolean hasQuantumGenerators = ModList.get().isLoaded("quantumgenerators");
            boolean hasJEI = ModList.get().isLoaded("jei");
            boolean oneprobe = ModList.get().isLoaded("oneprobe");
            boolean jade = ModList.get().isLoaded("jade");
            String message = String.valueOf(ChatFormatting.DARK_GRAY) + "================\n" + String.valueOf(ChatFormatting.GREEN) + Localization.translate("iu.mod.name") + " " + modVersion + "\n" + String.valueOf(ChatFormatting.WHITE) + Localization.translate("iu.addons.installed") + "\n" + this.formatAddonStatus("Power Utilities", hasPowerUtilities) + "\n" + this.formatAddonStatus("Simply Quarry", hasSimplyQuarry) + "\n" + this.formatAddonStatus("Quantum Generators", hasQuantumGenerators) + "\n\n" + String.valueOf(ChatFormatting.YELLOW) + Localization.translate("iu.addons.required") + "\n" + this.formatAddonStatus("JEI", hasJEI) + "\n" + this.formatAddonStatus("One Probe", oneprobe) + "\n" + this.formatAddonStatus("Jade", jade) + "\n" + String.valueOf(ChatFormatting.DARK_GRAY) + "================";
            IUCore.proxy.messagePlayer(player, message);
            this.sendDiscordLink(player);
        }
    }

    private String formatAddonStatus(String addonName, boolean isInstalled) {
        return String.valueOf(ChatFormatting.WHITE) + " " + addonName + ": " + (isInstalled ? String.valueOf(ChatFormatting.GREEN) + "[\u2611]" : String.valueOf(ChatFormatting.RED) + "[\u274c]");
    }

    private void sendDiscordLink(Player player) {
        MutableComponent discordMessage = Component.literal((String)("[" + Localization.translate("iu.discord.click") + "]")).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA).withUnderlined(Boolean.valueOf(true)).withClickEvent(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://discord.gg/nFHcxqVx")));
        MutableComponent fullMessage = Component.literal((String)(Localization.translate("iu.discord.question") + " ")).withStyle(Style.EMPTY.withColor(ChatFormatting.AQUA)).append((Component)discordMessage);
        player.sendSystemMessage((Component)fullMessage);
    }
}

