/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.datagen.loader;

import com.denfop.items.ItemVeinSensor;
import com.denfop.utils.ModUtils;
import com.denfop.world.WorldBaseGen;
import com.denfop.world.vein.ChanceOre;
import com.denfop.world.vein.TypeVein;
import com.denfop.world.vein.VeinType;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;

@EventBusSubscriber(modid="industrialupgrade")
public class VeinDataLoader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new Gson();
    public static Map<ResourceLocation, VeinType> VEIN_DATA = new HashMap<ResourceLocation, VeinType>();

    public VeinDataLoader() {
        super(GSON, "vein");
    }

    protected void apply(Map<ResourceLocation, JsonElement> map, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : map.entrySet()) {
            try {
                Object e2;
                if (VEIN_DATA.containsKey(entry.getKey())) continue;
                JsonObject json = entry.getValue().getAsJsonObject();
                ArrayList<ChanceOre> inputs = new ArrayList<ChanceOre>();
                JsonArray inputsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"inputs");
                for (Object e2 : inputsArray) {
                    JsonObject obj = e2.getAsJsonObject();
                    String id = GsonHelper.getAsString((JsonObject)obj, (String)"id");
                    int chance = GsonHelper.getAsInt((JsonObject)obj, (String)"chance", (int)100);
                    inputs.add(new ChanceOre(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)id))).defaultBlockState(), chance, 0));
                }
                JsonArray colorsArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"colors");
                e2 = colorsArray.iterator();
                while (e2.hasNext()) {
                    JsonElement e3 = (JsonElement)e2.next();
                    JsonObject obj = e3.getAsJsonObject();
                    String id = GsonHelper.getAsString((JsonObject)obj, (String)"id");
                    int color = GsonHelper.getAsInt((JsonObject)obj, (String)"color", (int)ModUtils.convertRGBAcolorToInt(255, 255, 255));
                    ItemVeinSensor.dataColors.put(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)id))).defaultBlockState(), color);
                }
                ArrayList<BlockState> deposit = new ArrayList<BlockState>();
                JsonArray depositArray = GsonHelper.getAsJsonArray((JsonObject)json, (String)"deposit");
                for (JsonElement e4 : depositArray) {
                    JsonObject obj = e4.getAsJsonObject();
                    String id = GsonHelper.getAsString((JsonObject)obj, (String)"id");
                    deposit.add(((Block)BuiltInRegistries.BLOCK.get(ResourceLocation.tryParse((String)id))).defaultBlockState());
                }
                VeinType type = new VeinType((BlockState)deposit.get(0), TypeVein.SMALL, inputs);
                WorldBaseGen.veinTypes.add(type);
                VEIN_DATA.put(entry.getKey(), type);
            }
            catch (Exception ex) {
                System.err.println("[VeinLoader] Error parsing file " + String.valueOf(entry.getKey()) + ": " + ex.getMessage());
            }
        }
        for (VeinType veinType : VEIN_DATA.values()) {
            for (ChanceOre chanceOre : veinType.getOres()) {
                BlockState state = chanceOre.getBlock();
                if (WorldBaseGen.idToblockStateMap.containsKey(state)) continue;
                WorldBaseGen.idToblockStateMap.put(state, WorldBaseGen.id);
                WorldBaseGen.blockStateMap.put(WorldBaseGen.id, state);
                ++WorldBaseGen.id;
            }
        }
        System.out.println("[VeinLoader] Vein files loaded: " + VEIN_DATA.size());
    }

    @SubscribeEvent
    public static void onAddReloadListeners(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)new VeinDataLoader());
    }
}

