/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.cool;

import com.denfop.api.cool.CoolTick;
import com.denfop.api.cool.CoolTickList;
import com.denfop.api.cool.ICoolAcceptor;
import com.denfop.api.cool.ICoolConductor;
import com.denfop.api.cool.ICoolEmitter;
import com.denfop.api.cool.ICoolSink;
import com.denfop.api.cool.ICoolSource;
import com.denfop.api.cool.ICoolTile;
import com.denfop.api.cool.InfoCable;
import com.denfop.api.cool.Path;
import com.denfop.api.energy.ConductorInfo;
import com.denfop.api.sytem.InfoTile;
import com.denfop.world.WorldBaseGen;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Tuple;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CoolNetLocal {
    final CoolTickList<CoolTick<ICoolSource, Path>> senderPath = new CoolTickList();
    private final Map<BlockPos, ICoolTile> chunkCoordinatesICoolTileMap;
    List<ICoolSource> sourceToUpdateList = new ArrayList<ICoolSource>();

    CoolNetLocal() {
        this.chunkCoordinatesICoolTileMap = new HashMap<BlockPos, ICoolTile>();
    }

    public void addTile(ICoolTile tile1) {
        this.addTileEntity(tile1.getPos(), tile1);
    }

    public void addTile(ICoolTile tile, BlockEntity tileentity) {
        BlockPos coords = tileentity.getBlockPos();
        if (this.chunkCoordinatesICoolTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesICoolTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof ICoolAcceptor) {
            this.onTileEntityAdded((ICoolAcceptor)tile);
        }
        if (tile instanceof ICoolSource) {
            this.senderPath.add(new CoolTick((ICoolSource)tile, null));
        }
    }

    private void updateAdd(BlockPos pos, ICoolTile tile) {
        for (Direction dir : Direction.values()) {
            ICoolAcceptor receiver2;
            ICoolEmitter sender2;
            BlockPos pos1 = pos.offset(dir.getNormal());
            ICoolTile tile1 = this.chunkCoordinatesICoolTileMap.get(pos1);
            if (tile1 == null) continue;
            Direction inverseDirection2 = dir.getOpposite();
            if (tile1 instanceof ICoolEmitter && tile instanceof ICoolAcceptor) {
                sender2 = (ICoolEmitter)tile1;
                receiver2 = (ICoolAcceptor)tile;
                if (!sender2.emitsCoolTo(receiver2, dir.getOpposite()) || !receiver2.acceptsCoolFrom(sender2, inverseDirection2.getOpposite())) continue;
                tile1.AddCoolTile(tile, dir.getOpposite());
                tile.AddCoolTile(tile1, dir);
                continue;
            }
            if (!(tile1 instanceof ICoolAcceptor) || !(tile instanceof ICoolEmitter) || !(sender2 = (ICoolEmitter)tile).emitsCoolTo(receiver2 = (ICoolAcceptor)tile1, dir) || !receiver2.acceptsCoolFrom(sender2, inverseDirection2)) continue;
            tile1.AddCoolTile(tile, dir.getOpposite());
            tile.AddCoolTile(tile1, dir);
        }
    }

    public void onTileEntityAdded(ICoolAcceptor tile) {
        LinkedList<ICoolTile> tileEntitiesToCheck = new LinkedList<ICoolTile>();
        tileEntitiesToCheck.add(tile);
        long id = WorldBaseGen.random.nextLong();
        this.sourceToUpdateList = new LinkedList<ICoolSource>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ICoolTile currentTileEntity = (ICoolTile)tileEntitiesToCheck.pop();
            List<InfoTile<ICoolTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            for (InfoTile<ICoolTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == tile || ((ICoolTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ICoolTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ICoolSource) {
                    this.sourceToUpdateList.add((ICoolSource)validReceiver.tileEntity);
                    continue;
                }
                if (!(validReceiver.tileEntity instanceof ICoolConductor)) continue;
                tileEntitiesToCheck.push((ICoolTile)validReceiver.tileEntity);
            }
        }
        this.sourceToUpdateList = new ArrayList<ICoolSource>(this.sourceToUpdateList);
    }

    public void addTileEntity(BlockPos coords, ICoolTile tile) {
        if (this.chunkCoordinatesICoolTileMap.containsKey(coords)) {
            return;
        }
        this.chunkCoordinatesICoolTileMap.put(coords, tile);
        this.updateAdd(coords, tile);
        if (tile instanceof ICoolAcceptor) {
            this.onTileEntityAdded((ICoolAcceptor)tile);
        }
        if (tile instanceof ICoolSource) {
            this.senderPath.add(new CoolTick((ICoolSource)tile, null));
        }
    }

    public void removeTile(ICoolTile tile1) {
        this.removeTileEntity(tile1);
    }

    private void updateRemove(BlockPos pos, ICoolTile tile) {
        for (Direction dir : Direction.values()) {
            BlockPos pos1 = pos.offset(dir.getNormal());
            ICoolTile tile1 = this.chunkCoordinatesICoolTileMap.get(pos1);
            if (tile1 == null) continue;
            tile1.RemoveCoolTile(tile, dir.getOpposite());
        }
    }

    public void removeTileEntity(ICoolTile tile) {
        if (!this.chunkCoordinatesICoolTileMap.containsKey(tile.getPos())) {
            return;
        }
        BlockPos coord = tile.getPos();
        this.chunkCoordinatesICoolTileMap.remove(coord);
        if (tile instanceof ICoolAcceptor) {
            this.removeAll(this.getSources((ICoolAcceptor)tile));
        }
        if (tile instanceof ICoolSource) {
            this.remove((ICoolSource)tile);
        }
        this.updateRemove(coord, tile);
    }

    public double emitCoolFrom(ICoolSource CoolSource, double amount, CoolTick<ICoolSource, Path> tick) {
        List<Path> CoolPaths = tick.getList();
        if (CoolPaths == null) {
            Tuple<List<Path>, LinkedList<ICoolConductor>> tuple = this.discover(CoolSource, tick);
            tick.setList((List)tuple.getA());
            tick.setConductors((LinkedList)tuple.getB());
            CoolPaths = tick.getList();
        }
        boolean transmit = false;
        if (amount > 0.0) {
            for (Path CoolPath : CoolPaths) {
                double adding;
                ICoolSink CoolSink = CoolPath.target;
                double demandedCool = CoolSink.getDemandedCool();
                if (demandedCool <= 0.0 || (adding = Math.min(amount, demandedCool)) <= 0.0) continue;
                CoolSink.receivedCold(adding);
                transmit = true;
                if (!(adding > CoolPath.min)) continue;
                for (ConductorInfo CoolConductor : CoolPath.conductors) {
                    if (!(CoolConductor.getBreakdownEnergy() < adding)) break;
                    ((ICoolConductor)this.getTileEntity(CoolConductor.getPos())).removeConductor();
                }
            }
        }
        if (!transmit && CoolSource.isAllowed()) {
            CoolSource.setAllowed(false);
        }
        return amount;
    }

    public double emitCoolFromNotAllowed(ICoolSource CoolSource, double amount, CoolTick<ICoolSource, Path> tick) {
        List<Path> CoolPaths = tick.getList();
        if (CoolPaths == null) {
            Tuple<List<Path>, LinkedList<ICoolConductor>> tuple = this.discover(CoolSource, tick);
            tick.setList((List)tuple.getA());
            tick.setConductors((LinkedList)tuple.getB());
            CoolPaths = tick.getList();
        }
        for (Path CoolPath : CoolPaths) {
            double adding;
            ICoolSink CoolSink = CoolPath.target;
            double demandedCool = CoolSink.getDemandedCool();
            if (demandedCool <= 0.0) continue;
            if (CoolSink.needCooling()) {
                CoolSource.setAllowed(true);
            }
            if ((adding = Math.min(amount, demandedCool)) <= 0.0) continue;
            CoolSink.receivedCold(adding);
            if (!(adding > CoolPath.min)) continue;
            for (ConductorInfo CoolConductor : CoolPath.conductors) {
                if (!(CoolConductor.getBreakdownEnergy() < adding)) continue;
                ((ICoolConductor)this.getTileEntity(CoolConductor.getPos())).removeConductor();
            }
        }
        return amount;
    }

    public BlockEntity getTileFromICool(ICoolTile tile) {
        if (tile instanceof BlockEntity) {
            return (BlockEntity)tile;
        }
        return tile.getTile();
    }

    public Tuple<List<Path>, LinkedList<ICoolConductor>> discover(ICoolSource emitter, CoolTick<ICoolSource, Path> tick) {
        LinkedList<ICoolTile> tileEntitiesToCheck = new LinkedList<ICoolTile>();
        AbstractList energyPaths = new LinkedList();
        long id = WorldBaseGen.random.nextLong();
        emitter.setId(id);
        tileEntitiesToCheck.push(emitter);
        LinkedList<ICoolConductor> set = new LinkedList<ICoolConductor>();
        while (!tileEntitiesToCheck.isEmpty()) {
            ICoolTile currentTileEntity = (ICoolTile)tileEntitiesToCheck.pop();
            List<InfoTile<ICoolTile>> validReceivers = this.getValidReceivers(currentTileEntity);
            InfoCable cable = null;
            if (currentTileEntity instanceof ICoolConductor) {
                cable = ((ICoolConductor)currentTileEntity).getCoolCable();
            }
            for (InfoTile<ICoolTile> validReceiver : validReceivers) {
                if (validReceiver.tileEntity == emitter || ((ICoolTile)validReceiver.tileEntity).getIdNetwork() == id) continue;
                ((ICoolTile)validReceiver.tileEntity).setId(id);
                if (validReceiver.tileEntity instanceof ICoolSink) {
                    energyPaths.add(new Path((ICoolSink)validReceiver.tileEntity, validReceiver.direction));
                    continue;
                }
                Object t = validReceiver.tileEntity;
                if (!(t instanceof ICoolConductor)) continue;
                ICoolConductor conductor = (ICoolConductor)t;
                conductor.setCoolCable(new InfoCable(conductor, validReceiver.direction, cable));
                tileEntitiesToCheck.push((ICoolTile)validReceiver.tileEntity);
            }
        }
        int id1 = WorldBaseGen.random.nextInt();
        energyPaths = new ArrayList(energyPaths);
        block2: for (Path energyPath : energyPaths) {
            ICoolTile tileEntity = energyPath.target;
            energyPath.target.getEnergyTickList().add(tick.getSource());
            Direction energyBlockLink = energyPath.targetDirection;
            tileEntity = tileEntity.getCoolTiles().get(energyBlockLink);
            if (!(tileEntity instanceof ICoolConductor)) continue;
            InfoCable cable = ((ICoolConductor)tileEntity).getCoolCable();
            while (cable != null) {
                ICoolConductor energyConductor = cable.getConductor();
                energyPath.conductors.add(energyConductor.getCoolConductor());
                if (energyConductor.getHashCodeSource() != id1) {
                    energyConductor.setHashCodeSource(id1);
                    set.add(energyConductor);
                    if (energyConductor.getConductorBreakdownCold() - 1.0 < energyPath.getMin()) {
                        energyPath.setMin(energyConductor.getConductorBreakdownCold() - 1.0);
                    }
                }
                if ((cable = cable.getPrev()) != null) continue;
                continue block2;
            }
        }
        return new Tuple((Object)energyPaths, set);
    }

    public List<InfoTile<ICoolTile>> getValidReceivers(ICoolTile emitter) {
        BlockPos tile1 = emitter.getPos();
        if (tile1 != null) {
            return emitter.getCoolValidReceivers();
        }
        return Collections.emptyList();
    }

    public void onTickEnd() {
        if (!this.sourceToUpdateList.isEmpty()) {
            for (ICoolSource iCoolSource : this.sourceToUpdateList) {
                this.remove1(iCoolSource);
            }
            this.sourceToUpdateList.clear();
        }
        try {
            for (CoolTick coolTick : this.senderPath) {
                double removed;
                double i;
                ICoolSource entry = (ICoolSource)coolTick.getSource();
                if (entry == null) continue;
                double offered = entry.getOfferedCool();
                if (offered > 0.0 && entry.isAllowed()) {
                    for (i = 0.0; i < 1.0 && !((removed = offered - this.emitCoolFrom(entry, offered, coolTick)) <= 0.0); i += 1.0) {
                    }
                    continue;
                }
                if (entry.isAllowed()) continue;
                for (i = 0.0; i < 1.0 && !((removed = offered - this.emitCoolFromNotAllowed(entry, offered, coolTick)) <= 0.0); i += 1.0) {
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public ICoolTile getTileEntity(BlockPos pos) {
        return this.chunkCoordinatesICoolTileMap.get(pos);
    }

    public void remove1(ICoolSource par1) {
        for (CoolTick coolTick : this.senderPath) {
            if (coolTick.getSource() != par1) continue;
            if (coolTick.getList() != null) {
                for (Path path : coolTick.getList()) {
                    path.target.getEnergyTickList().remove(coolTick.getSource());
                }
            }
            coolTick.setList(null);
            break;
        }
    }

    public void remove(ICoolSource par1) {
        CoolTick<ICoolSource, Path> coolTick = this.senderPath.removeSource(par1);
        if (coolTick != null && coolTick.getList() != null) {
            for (Path path : coolTick.getList()) {
                path.target.getEnergyTickList().remove(coolTick.getSource());
            }
        }
    }

    public void removeAll(List<CoolTick<ICoolSource, Path>> par1) {
        if (par1 == null) {
            return;
        }
        for (CoolTick<ICoolSource, Path> IEnergySource2 : par1) {
            if (IEnergySource2.getList() != null) {
                for (Path path : IEnergySource2.getList()) {
                    path.target.getEnergyTickList().remove(IEnergySource2.getSource());
                }
            }
            IEnergySource2.setList(null);
        }
    }

    public List<CoolTick<ICoolSource, Path>> getSources(ICoolAcceptor par1) {
        if (par1 instanceof ICoolSink) {
            LinkedList<CoolTick<ICoolSource, Path>> list = new LinkedList<CoolTick<ICoolSource, Path>>();
            for (CoolTick coolTick : this.senderPath) {
                if (!((ICoolSink)par1).getEnergyTickList().contains(coolTick.getSource())) continue;
                list.add(coolTick);
            }
            return list;
        }
        if (par1 instanceof ICoolConductor) {
            LinkedList<CoolTick<ICoolSource, Path>> list = new LinkedList<CoolTick<ICoolSource, Path>>();
            for (CoolTick coolTick : this.senderPath) {
                if (!coolTick.getConductors().contains(par1)) continue;
                list.add(coolTick);
            }
            return list;
        }
        return Collections.emptyList();
    }

    public void onUnload() {
        this.senderPath.clear();
        this.chunkCoordinatesICoolTileMap.clear();
    }
}

