/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.componets.AbstractComponent;
import com.denfop.componets.RedstoneHandler;
import com.denfop.tiles.base.TileEntityInventory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class Redstone
extends AbstractComponent {
    private final List<RedstoneHandler> changeSubscribers = new ArrayList<RedstoneHandler>();
    protected int redstoneInput;

    public Redstone(TileEntityInventory parent) {
        super(parent);
    }

    @Override
    public void onLoaded() {
        super.onLoaded();
        this.update();
    }

    @Override
    public void onUnloaded() {
        super.onUnloaded();
    }

    @Override
    public void onNeighborChange(BlockState srcBlock, BlockPos neighborPos) {
        super.onNeighborChange(srcBlock, neighborPos);
        this.update();
    }

    public void update() {
        try {
            Level world = this.parent.getLevel();
            int input = world.getBestNeighborSignal(this.parent.getBlockPos());
            if (input != this.redstoneInput) {
                this.redstoneInput = input;
                if (this.changeSubscribers != null) {
                    for (RedstoneHandler subscriber : this.changeSubscribers) {
                        subscriber.action(input);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getRedstoneInput() {
        return this.redstoneInput;
    }

    public boolean hasRedstoneInput() {
        return this.redstoneInput > 0;
    }

    public void subscribe(RedstoneHandler handler) {
        if (handler == null) {
            throw new NullPointerException("null handler");
        }
        this.changeSubscribers.add(handler);
    }
}

