/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.energy.EnergyNetGlobal;
import com.denfop.api.energy.IEnergyTile;
import com.denfop.api.sytem.InfoTile;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.Energy;
import com.denfop.tiles.base.TileEntityBlock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;

public abstract class EnergyNetDelegate
implements IEnergyTile {
    public final BufferEnergy buffer;
    public final BlockPos worldPosition;
    private final boolean clientSide;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public boolean receivingDisabled;
    public boolean sendingSidabled;
    public double tick;
    public boolean limit;
    public double limit_amount = 0.0;
    protected double pastEnergy;
    protected double perenergy;
    protected double pastEnergy1;
    protected double perenergy1;
    Map<Direction, IEnergyTile> energyConductorMap = new HashMap<Direction, IEnergyTile>();
    List<InfoTile<IEnergyTile>> validReceivers = new LinkedList<InfoTile<IEnergyTile>>();
    private long id;

    public EnergyNetDelegate(Energy block) {
        this.worldPosition = block.parent.pos;
        this.clientSide = block.parent.getLevel().isClientSide;
        this.sinkDirections = block.sinkDirections;
        this.sourceDirections = block.sourceDirections;
        this.buffer = block.buffer;
    }

    public EnergyNetDelegate(TileEntityBlock block, Set<Direction> sourceDirection, BufferEnergy bufferEnergy) {
        this.worldPosition = block.pos;
        this.clientSide = block.getLevel().isClientSide;
        this.sinkDirections = new HashSet<Direction>();
        this.sourceDirections = sourceDirection;
        this.buffer = bufferEnergy;
    }

    public double getSourceEnergy() {
        if (!this.limit) {
            return Math.min(this.buffer.storage, EnergyNetGlobal.instance.getPowerFromTier(this.buffer.sourceTier));
        }
        return Math.min(this.buffer.storage, this.limit_amount);
    }

    @Override
    public long getIdNetwork() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public void setSinkDirections(Set<Direction> sinkDirections) {
        this.sinkDirections = sinkDirections;
    }

    public void setSourceDirections(Set<Direction> sourceDirections) {
        this.sourceDirections = sourceDirections;
    }

    public Map<Direction, IEnergyTile> getConductors() {
        return this.energyConductorMap;
    }

    @Override
    public void RemoveTile(IEnergyTile tile, Direction facing1) {
        if (!this.clientSide) {
            this.energyConductorMap.remove(facing1);
            Iterator<InfoTile<IEnergyTile>> iter = this.validReceivers.iterator();
            while (iter.hasNext()) {
                InfoTile<IEnergyTile> tileInfoTile = iter.next();
                if (tileInfoTile.tileEntity != tile) continue;
                iter.remove();
                break;
            }
        }
    }

    @Override
    public List<InfoTile<IEnergyTile>> getValidReceivers() {
        return this.validReceivers;
    }

    @Override
    public void AddTile(IEnergyTile tile, Direction facing1) {
        if (!this.clientSide && !this.energyConductorMap.containsKey(facing1)) {
            this.energyConductorMap.put(facing1, tile);
            this.validReceivers.add(new InfoTile<IEnergyTile>(tile, facing1.getOpposite()));
        }
    }
}

