/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyType;
import com.denfop.blocks.FluidName;
import com.denfop.componets.ComponentBaseEnergy;
import com.denfop.effects.EffectsRegister;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class ComponentSteamEnergy
extends ComponentBaseEnergy {
    FluidTank fluidTank;

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier, false);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier);
    }

    public ComponentSteamEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<Direction> sinkDirections, List<Direction> sourceDirections, int sinkTier, int sourceTier, boolean fullEnergy) {
        super(type, parent, capacity, sinkDirections, sourceDirections, sinkTier, sourceTier);
    }

    public static ComponentSteamEnergy asBasicSink(TileEntityInventory parent, double capacity) {
        return ComponentSteamEnergy.asBasicSink(parent, capacity, 1);
    }

    public static ComponentSteamEnergy asBasicSink(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentSteamEnergy(EnergyType.STEAM, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentSteamEnergy asBasicSource(TileEntityInventory parent, double capacity) {
        return ComponentSteamEnergy.asBasicSource(parent, capacity, 1);
    }

    public static ComponentSteamEnergy asBasicSource(TileEntityInventory parent, double capacity, int tier) {
        return new ComponentSteamEnergy(EnergyType.STEAM, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    @Override
    public void onPlaced(ItemStack stack, LivingEntity placer, Direction facing) {
        super.onPlaced(stack, placer, facing);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void updateEntityClient() {
        super.updateEntityClient();
        if (this.parent.getActive() && this.parent.getWorld().getGameTime() % 4L == 0L) {
            double x = this.parent.getBlockPos().getX();
            double y = (double)this.parent.getBlockPos().getY() + 1.0;
            double z = this.parent.getBlockPos().getZ();
            this.parent.getLevel().addParticle((ParticleOptions)EffectsRegister.STEAM_ASH.get(), x, y, z, 0.0, 0.1, 0.0);
        }
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if ((double)this.fluidTank.getFluid().getAmount() != this.buffer.storage && this.buffer.storage > (double)this.fluidTank.getFluid().getAmount()) {
            this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), (int)this.buffer.storage - this.fluidTank.getFluid().getAmount()), IFluidHandler.FluidAction.EXECUTE);
        }
        if ((double)this.fluidTank.getFluid().getAmount() != this.buffer.storage && this.buffer.storage < (double)this.fluidTank.getFluid().getAmount()) {
            this.fluidTank.drain(this.fluidTank.getFluid().getAmount() - (int)this.buffer.storage, IFluidHandler.FluidAction.EXECUTE);
        }
    }

    @Override
    public double addEnergy(double amount) {
        super.addEnergy(amount);
        if (this.fluidTank.getFluid().isEmpty() && amount >= 1.0) {
            this.fluidTank.fill(new FluidStack((Fluid)FluidName.fluidsteam.getInstance().get(), (int)this.buffer.storage), IFluidHandler.FluidAction.EXECUTE);
        } else if (!this.fluidTank.getFluid().isEmpty()) {
            this.fluidTank.getFluid().setAmount((int)this.buffer.storage);
        }
        return amount;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public boolean useEnergy(double amount) {
        super.useEnergy(amount);
        if (!this.fluidTank.getFluid().isEmpty()) {
            this.fluidTank.getFluid().setAmount((int)this.buffer.storage);
            if (this.fluidTank.getFluid().getAmount() == 0) {
                this.fluidTank.setFluid(FluidStack.EMPTY);
            }
        }
        return true;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }

    public void setFluidTank(FluidTank fluidTank) {
        this.fluidTank = fluidTank;
    }
}

