/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.api.sytem.EnergyEvent;
import com.denfop.api.sytem.EnergyType;
import com.denfop.api.sytem.EnumTypeEvent;
import com.denfop.api.sytem.ITile;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.BufferEnergy;
import com.denfop.componets.system.EnergyNetDelegate;
import com.denfop.componets.system.EnergyNetDelegateDual;
import com.denfop.componets.system.EnergyNetDelegateSink;
import com.denfop.componets.system.EnergyNetDelegateSource;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.network.packet.PacketUpdateRadiationValue;
import com.denfop.tiles.base.TileEntityInventory;
import com.denfop.utils.ModUtils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class ComponentBaseEnergy
extends AbstractComponent {
    private final EnergyType type;
    private final double defaultCapacity;
    public Set<Direction> sinkDirections;
    public Set<Direction> sourceDirections;
    public EnergyNetDelegate delegate;
    public boolean loaded;
    public final BufferEnergy buffer;

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity) {
        this(type, parent, capacity, Collections.emptySet(), Collections.emptySet(), 1);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int tier) {
        this(type, parent, capacity, sinkDirections, sourceDirections, tier, tier);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, Set<Direction> sinkDirections, Set<Direction> sourceDirections, int sinkTier, int sourceTier) {
        super(parent);
        this.type = type;
        this.defaultCapacity = capacity;
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        this.buffer = new BufferEnergy(0.0, capacity, sinkTier, sourceTier);
    }

    public ComponentBaseEnergy(EnergyType type, TileEntityInventory parent, double capacity, List<Direction> sinkDirections, List<Direction> sourceDirections, int sinkTier, int sourceTier) {
        super(parent);
        this.type = type;
        this.defaultCapacity = capacity;
        this.sinkDirections = new HashSet<Direction>(sinkDirections);
        this.sourceDirections = new HashSet<Direction>(sourceDirections);
        this.buffer = new BufferEnergy(0.0, capacity, sinkTier, sourceTier);
    }

    public void setReceivingEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.receivingDisabled = !enabled;
        }
    }

    public void setSendingEnabled(boolean enabled) {
        if (this.delegate != null) {
            this.delegate.sendingSidabled = !enabled;
        }
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSink(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSink(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, ModUtils.allFacings, Collections.emptySet(), tier);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity) {
        return ComponentBaseEnergy.asBasicSource(type, parent, capacity, 1);
    }

    public static ComponentBaseEnergy asBasicSource(EnergyType type, TileEntityInventory parent, double capacity, int tier) {
        return new ComponentBaseEnergy(type, parent, capacity, Collections.emptySet(), ModUtils.allFacings, tier);
    }

    public EnergyType getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return super.toString() + this.type.name().toLowerCase();
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        this.buffer.storage = nbt.getDouble("storage");
        this.buffer.capacity = nbt.getDouble("capacity");
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag ret = new CompoundTag();
        ret.putDouble("storage", this.buffer.storage);
        ret.putDouble("capacity", this.buffer.capacity);
        return ret;
    }

    @Override
    public boolean isServer() {
        return false;
    }

    @Override
    public void onLoaded() {
        assert (this.delegate == null);
        if (this.buffer.capacity < this.defaultCapacity) {
            this.buffer.capacity = this.defaultCapacity;
        }
        if (!this.parent.getLevel().isClientSide) {
            if (!this.sinkDirections.isEmpty() || !this.sourceDirections.isEmpty()) {
                this.createDelegate();
                NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.LOAD, this.type, this.delegate));
            }
            this.loaded = true;
        }
    }

    private void createDelegate() {
        if (this.delegate == null) {
            this.delegate = this.sinkDirections.isEmpty() ? new EnergyNetDelegateSource(this) : (this.sourceDirections.isEmpty() ? new EnergyNetDelegateSink(this) : new EnergyNetDelegateDual(this));
        }
    }

    @Override
    public void onUnloaded() {
        if (this.delegate != null) {
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
            this.delegate = null;
        }
        this.loaded = false;
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeDouble(this.buffer.capacity);
        buffer.writeDouble(this.buffer.storage);
        buffer.writeInt(this.buffer.sourceTier);
        buffer.writeInt(this.buffer.sinkTier);
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.buffer.capacity);
        buffer.writeDouble(this.buffer.storage);
        buffer.writeInt(this.buffer.sourceTier);
        buffer.writeInt(this.buffer.sinkTier);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.buffer.capacity = is.readDouble();
        this.buffer.storage = is.readDouble();
        this.buffer.sourceTier = is.readInt();
        this.buffer.sinkTier = is.readInt();
    }

    public double getCapacity() {
        return this.buffer.capacity;
    }

    public void setCapacity(double capacity) {
        this.buffer.capacity = capacity;
        if (this.buffer.storage > this.buffer.capacity) {
            this.buffer.storage = capacity;
        }
    }

    public double getEnergy() {
        return this.buffer.storage;
    }

    public double getFillRatio() {
        return this.buffer.storage / this.buffer.capacity;
    }

    public double addEnergy(double amount) {
        amount = Math.min(this.buffer.capacity - this.buffer.storage, amount);
        this.buffer.storage += amount;
        return amount;
    }

    @Override
    public void blockBreak() {
        Level level;
        if (this.getType() == EnergyType.RADIATION) {
            new PacketUpdateRadiationValue(new ChunkPos(this.parent.getBlockPos()), (int)this.buffer.storage, (ServerLevel)this.parent.getWorld());
        } else if (this.getType() == EnergyType.EXPERIENCE && this.buffer.storage > 0.0 && (level = this.parent.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            double f = 0.7;
            double dx = serverLevel.random.nextDouble() * 1.0 + (1.0 - f) * 0.5;
            double dy = serverLevel.random.nextDouble() * f + (1.0 - f) * 0.5;
            double dz = serverLevel.random.nextDouble() * f + (1.0 - f) * 0.5;
            int xpAmount = ExperienceOrb.getExperienceValue((int)((int)this.buffer.storage));
            ExperienceOrb xpOrb = new ExperienceOrb((Level)serverLevel, (double)this.parent.getBlockPos().getX() + dx, (double)this.parent.getBlockPos().getY() + dy, (double)this.parent.getBlockPos().getZ() + dz, xpAmount);
            serverLevel.addFreshEntity((Entity)xpOrb);
        }
    }

    public boolean canUseEnergy(double amount) {
        return this.buffer.storage >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.buffer.storage >= amount) {
            this.buffer.storage -= amount;
            return true;
        }
        return false;
    }

    public double useEnergy(double amount, boolean simulate) {
        double ret = Math.abs(Math.max(0.0, amount - this.buffer.storage) - amount);
        if (!simulate) {
            this.buffer.storage -= ret;
        }
        return ret;
    }

    public int getSinkTier() {
        return this.buffer.sinkTier;
    }

    public void setSinkTier(int tier) {
        this.buffer.sinkTier = tier;
    }

    public int getSourceTier() {
        return this.buffer.sourceTier;
    }

    public void setSourceTier(int tier) {
        this.buffer.sourceTier = tier;
    }

    public void setDirections(Set<Direction> sinkDirections, Set<Direction> sourceDirections) {
        this.sinkDirections = sinkDirections;
        this.sourceDirections = sourceDirections;
        if (this.delegate != null) {
            assert (!this.parent.getLevel().isClientSide);
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.UNLOAD, this.type, this.delegate));
        }
        if (sinkDirections.isEmpty() && sourceDirections.isEmpty()) {
            this.delegate = null;
        } else if (this.delegate == null && this.loaded) {
            this.createDelegate();
        }
        if (this.delegate != null) {
            this.delegate.sourceDirections = sourceDirections;
            this.delegate.sinkDirections = sinkDirections;
            this.delegate.energyConductorMap.clear();
            this.delegate.getValidReceivers(this.type).clear();
            NeoForge.EVENT_BUS.post((Event)new EnergyEvent(this.parent.getLevel(), EnumTypeEvent.LOAD, this.type, this.delegate));
        }
    }

    public ITile getDelegate() {
        return this.delegate;
    }

    public double getFreeEnergy() {
        return this.buffer.capacity - this.buffer.storage;
    }
}

