/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.componets;

import com.denfop.IUItem;
import com.denfop.Localization;
import com.denfop.api.pollution.PollutionAirLoadEvent;
import com.denfop.api.pollution.PollutionAirUnLoadEvent;
import com.denfop.api.windsystem.WindSystem;
import com.denfop.componets.AbstractComponent;
import com.denfop.componets.PollutionMechanism;
import com.denfop.componets.TypePurifierJob;
import com.denfop.network.packet.CustomPacketBuffer;
import com.denfop.tiles.base.TileEntityInventory;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

public class AirPollutionComponent
extends AbstractComponent {
    private final PollutionMechanism pollution;
    private double default_pollution;
    private double percent = 1.0;

    public AirPollutionComponent(TileEntityInventory parent, double pollution) {
        super(parent);
        this.pollution = new PollutionMechanism(new ChunkPos(parent.pos));
        this.default_pollution = pollution;
    }

    public static void spawnAirPollutionDirected(Level level, BlockPos pos, RandomSource random) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel server = (ServerLevel)level;
        Vec3 Vec32 = WindSystem.windSystem.getWindSide().getDirectionVector();
        double dx = 0.0;
        double dz = 0.0;
        double magnitude = Math.sqrt((dx += Vec32.x) * dx + (dz += Vec32.z) * dz);
        if (magnitude != 0.0) {
            dx /= magnitude;
            dz /= magnitude;
        }
        double x = (double)pos.getX() + 0.5;
        double y = (double)pos.getY() + 1.2;
        double z = (double)pos.getZ() + 0.5;
        if (random.nextFloat() < 0.5f) {
            server.sendParticles((ParticleOptions)ParticleTypes.CLOUD, x, y, z, 0, 0.05, 0.1, 0.05, 0.1);
            for (int i = 0; i < 2; ++i) {
                double ox = x + (random.nextDouble() - 0.5) * 0.4;
                double oy = y + random.nextDouble() * 0.2;
                double oz = z + (random.nextDouble() - 0.5) * 0.4;
                double vx = dx * 0.05 + (random.nextDouble() - 0.5) * 0.01;
                double vz = dz * 0.05 + (random.nextDouble() - 0.5) * 0.01;
                server.sendParticles((ParticleOptions)ParticleTypes.CAMPFIRE_SIGNAL_SMOKE, ox, oy, oz, 0, vx, 0.1, vz, 1.0);
            }
        }
    }

    @Override
    public CompoundTag writeToNbt() {
        CompoundTag tagCompound = super.writeToNbt();
        tagCompound.putDouble("percent", this.percent);
        return tagCompound;
    }

    @Override
    public boolean isClient() {
        return true;
    }

    @Override
    public void readFromNbt(CompoundTag nbt) {
        super.readFromNbt(nbt);
        this.percent = nbt.getDouble("percent");
    }

    @Override
    public TypePurifierJob getPurifierJob() {
        return TypePurifierJob.ItemStack;
    }

    @Override
    public boolean canUsePurifier(Player player) {
        return this.percent != 1.0;
    }

    @Override
    public ItemStack getItemStackUpgrade() {
        if (this.percent == 0.0) {
            this.percent = 0.5;
            return new ItemStack((ItemLike)IUItem.antiairpollution1.getItem());
        }
        this.percent = 1.0;
        return new ItemStack((ItemLike)IUItem.antiairpollution.getItem());
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> ret = super.getDrops();
        if (this.percent == 0.0) {
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution1.getItem()));
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution.getItem()));
        } else if (this.percent == 0.5) {
            ret.add(new ItemStack((ItemLike)IUItem.antiairpollution.getItem()));
        }
        return ret;
    }

    @Override
    public boolean onBlockActivated(Player player, InteractionHand hand) {
        if (!this.parent.getLevel().isClientSide) {
            ItemStack stack = player.getItemInHand(hand);
            Item item = stack.getItem();
            if (this.percent == 1.0 && item == IUItem.antiairpollution.getItem()) {
                stack.shrink(1);
                this.percent = 0.5;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            } else if (this.percent == 0.5 && item == IUItem.antiairpollution1.getItem()) {
                stack.shrink(1);
                this.percent = 0.0;
                if (this.parent.getActive()) {
                    this.setPollution(this.default_pollution * this.percent);
                } else {
                    this.setPollution(0.0);
                }
            }
        }
        return super.onBlockActivated(player, hand);
    }

    @Override
    public void onContainerUpdate(ServerPlayer player) {
        CustomPacketBuffer buffer = new CustomPacketBuffer(16, player.registryAccess());
        buffer.writeDouble(this.pollution.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        buffer.flip();
        this.setNetworkUpdate(player, buffer);
    }

    @Override
    public CustomPacketBuffer updateComponent() {
        CustomPacketBuffer buffer = super.updateComponent();
        buffer.writeDouble(this.pollution.pollution);
        buffer.writeDouble(this.default_pollution);
        buffer.writeDouble(this.percent);
        return buffer;
    }

    @Override
    public void onNetworkUpdate(CustomPacketBuffer is) throws IOException {
        this.pollution.pollution = is.readDouble();
        this.default_pollution = is.readDouble();
        this.percent = is.readDouble();
    }

    @Override
    public boolean isServer() {
        return true;
    }

    @Override
    public void updateEntityServer() {
        super.updateEntityServer();
        if (this.parent.getWorld().getGameTime() % 20L == 0L && this.parent.getActive()) {
            AirPollutionComponent.spawnAirPollutionDirected(this.parent.getWorld(), this.parent.getPos(), this.parent.getWorld().random);
        }
        if (this.parent.getActive()) {
            this.setPollution(this.default_pollution * this.percent);
        } else {
            this.setPollution(0.0);
        }
    }

    @Override
    public void onLoaded() {
        if (!this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.getLevel(), this.pollution));
        }
    }

    public double getDefault_pollution() {
        return this.default_pollution;
    }

    @Override
    public void onUnloaded() {
        if (!this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.getLevel(), this.pollution));
        }
    }

    @Override
    public void addInformation(ItemStack stack, List<String> tooltip) {
        super.addInformation(stack, tooltip);
        if (this.parent != null && this.parent.getWorld() == null) {
            tooltip.add(Localization.translate("iu.pollution.air.info") + " " + String.format("%.2f", this.default_pollution) + Localization.translate("iu.pollution.air.info1"));
        }
    }

    public void setPollution(double pollution) {
        if (this.pollution.pollution != pollution * this.percent && !this.parent.getLevel().isClientSide && this.parent.getLevel().dimension() == Level.OVERWORLD) {
            NeoForge.EVENT_BUS.post((Event)new PollutionAirUnLoadEvent(this.parent.getLevel(), this.pollution));
            this.pollution.pollution = pollution * this.percent;
            NeoForge.EVENT_BUS.post((Event)new PollutionAirLoadEvent(this.parent.getLevel(), this.pollution));
        }
    }
}

