/*
 * Decompiled with CFR 0.152.
 */
package com.denfop.blocks.mechanism;

import com.denfop.IUCore;
import com.denfop.api.tile.IMultiTileBlock;
import com.denfop.blocks.state.DefaultDrop;
import com.denfop.blocks.state.HarvestTool;
import com.denfop.tiles.base.TileEntityBlock;
import com.denfop.tiles.base.TileNeutronGenerator;
import com.denfop.tiles.mechanism.TileGenerationMicrochip;
import com.denfop.tiles.mechanism.TileGenerationStone;
import com.denfop.tiles.mechanism.TileModuleMachine;
import com.denfop.tiles.mechanism.dual.heat.TileAlloySmelter;
import com.denfop.tiles.mechanism.generator.energy.coal.TileEntityGeneratorAdv;
import com.denfop.tiles.mechanism.generator.energy.coal.TileEntityGeneratorImp;
import com.denfop.tiles.mechanism.generator.energy.coal.TileEntityGeneratorPer;
import com.denfop.tiles.mechanism.generator.things.matter.TileAdvancedMatter;
import com.denfop.tiles.mechanism.generator.things.matter.TileImprovedMatter;
import com.denfop.tiles.mechanism.generator.things.matter.TileUltimateMatter;
import com.denfop.tiles.mechanism.quarry.TileAdvQuantumQuarry;
import com.denfop.tiles.mechanism.quarry.TileImpQuantumQuarry;
import com.denfop.tiles.mechanism.quarry.TilePerQuantumQuarry;
import com.denfop.tiles.mechanism.quarry.TileQuantumQuarry;
import com.denfop.utils.ModUtils;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.fml.ModContainer;
import net.neoforged.neoforge.registries.DeferredHolder;

public enum BlockBaseMachine implements IMultiTileBlock
{
    adv_matter(TileAdvancedMatter.class, 1),
    imp_matter(TileImprovedMatter.class, 2),
    per_matter(TileUltimateMatter.class, 3),
    alloy_smelter(TileAlloySmelter.class, 4),
    neutron_generator(TileNeutronGenerator.class, 5),
    generator_microchip(TileGenerationMicrochip.class, 6),
    gen_stone(TileGenerationStone.class, 7),
    quantum_quarry(TileQuantumQuarry.class, 8),
    modulator(TileModuleMachine.class, 9),
    adv_gen(TileEntityGeneratorAdv.class, 10),
    imp_gen(TileEntityGeneratorImp.class, 11),
    per_gen(TileEntityGeneratorPer.class, 12),
    adv_quantum_quarry(TileAdvQuantumQuarry.class, 13),
    imp_quantum_quarry(TileImpQuantumQuarry.class, 14),
    per_quantum_quarry(TilePerQuantumQuarry.class, 15);

    private final Class<? extends TileEntityBlock> teClass;
    private final int itemMeta;
    int idBlock;
    private TileEntityBlock dummyTe;
    private BlockState defaultState;
    private DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockType;

    private BlockBaseMachine(Class<? extends TileEntityBlock> teClass, int itemMeta) {
        this.teClass = teClass;
        this.itemMeta = itemMeta;
    }

    @Override
    public int getIDBlock() {
        return this.idBlock;
    }

    @Override
    public void setIdBlock(int id) {
        this.idBlock = id;
    }

    @Override
    public void buildDummies() {
        ModContainer mc = IUCore.instance.modContainer;
        if (mc == null || !"industrialupgrade".equals(mc.getModId())) {
            throw new IllegalAccessError("Don't mess with this please.");
        }
        if (this.getTeClass() != null) {
            try {
                this.dummyTe = (TileEntityBlock)((Object)this.teClass.getConstructors()[0].newInstance(BlockPos.ZERO, this.defaultState));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public void setDefaultState(BlockState blockState) {
        this.defaultState = blockState;
    }

    @Override
    public void setType(DeferredHolder<BlockEntityType<?>, BlockEntityType<? extends TileEntityBlock>> blockEntityType) {
        this.blockType = blockEntityType;
    }

    @Override
    public BlockEntityType<? extends TileEntityBlock> getBlockType() {
        return (BlockEntityType)this.blockType.get();
    }

    @Override
    public String getMainPath() {
        return "basemachine";
    }

    @Override
    public String getName() {
        return this.name();
    }

    @Override
    public int getId() {
        return this.itemMeta;
    }

    @Override
    public boolean hasItem() {
        return true;
    }

    @Override
    public Class<? extends TileEntityBlock> getTeClass() {
        return this.teClass;
    }

    @Override
    public boolean hasActive() {
        return true;
    }

    @Override
    @Nonnull
    public Set<Direction> getSupportedFacings() {
        return ModUtils.horizontalFacings;
    }

    @Override
    public float getHardness() {
        return 1.0f;
    }

    @Override
    @Nonnull
    public HarvestTool getHarvestTool() {
        return HarvestTool.Wrench;
    }

    @Override
    @Nonnull
    public DefaultDrop getDefaultDrop() {
        return DefaultDrop.Machine;
    }

    @Override
    public boolean allowWrenchRotating() {
        return true;
    }

    @Override
    public TileEntityBlock getDummyTe() {
        return this.dummyTe;
    }
}

